/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.mysql;

import com.querydsl.core.testutil.MySQL;
import com.querydsl.core.types.Path;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.QGeneratedKeysEntity;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.SQLInsertClause;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MySQL.class})
public class GeneratedKeysMySQLTest {
    private Connection conn;
    private Statement stmt;

    @Before
    public void setUp() throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver");
        String url = "jdbc:mysql://localhost:3306/querydsl";
        this.conn = DriverManager.getConnection(url, "querydsl", "querydsl");
        this.stmt = this.conn.createStatement();
    }

    @After
    public void tearDown() throws SQLException {
        try {
            this.stmt.close();
        }
        finally {
            this.conn.close();
        }
    }

    @Test
    public void test() throws SQLException {
        this.stmt.execute("drop table if exists GENERATED_KEYS");
        this.stmt.execute("create table GENERATED_KEYS(ID int AUTO_INCREMENT PRIMARY KEY, NAME varchar(30))");
        QGeneratedKeysEntity entity = new QGeneratedKeysEntity("entity");
        SQLInsertClause insertClause = new SQLInsertClause(this.conn, (SQLTemplates)new H2Templates(), (RelationalPath)entity);
        ResultSet rs = ((SQLInsertClause)insertClause.set((Path)entity.name, (Object)"Hello")).executeWithKeys();
        ResultSetMetaData md = rs.getMetaData();
        System.out.println(md.getColumnName(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        insertClause = new SQLInsertClause(this.conn, (SQLTemplates)new H2Templates(), (RelationalPath)entity);
        rs = ((SQLInsertClause)insertClause.set((Path)entity.name, (Object)"World")).executeWithKeys();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

