/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.mysql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.domain.QSurvey;
import com.querydsl.sql.mysql.MySQLQueryFactory;
import java.sql.Connection;
import java.util.function.Supplier;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySQLQueryFactoryTest {
    private MySQLQueryFactory queryFactory;

    @Before
    public void setUp() {
        Supplier<Connection> provider = () -> (Connection)EasyMock.createNiceMock(Connection.class);
        this.queryFactory = new MySQLQueryFactory(SQLTemplates.DEFAULT, provider);
    }

    @Test
    public void query() {
        Assert.assertNotNull((Object)this.queryFactory.query());
    }

    @Test
    public void from() {
        Assert.assertNotNull((Object)this.queryFactory.from((Expression)QSurvey.survey));
    }

    @Test
    public void delete() {
        Assert.assertNotNull((Object)this.queryFactory.delete((RelationalPath)QSurvey.survey));
    }

    @Test
    public void insert() {
        Assert.assertNotNull((Object)this.queryFactory.insert((RelationalPath)QSurvey.survey));
    }

    @Test
    public void insertIgnore() {
        SQLInsertClause clause = this.queryFactory.insertIgnore((RelationalPath)QSurvey.survey);
        Assert.assertEquals((Object)"insert ignore into SURVEY\nvalues ()", (Object)clause.toString());
    }

    @Test
    public void insertOnDuplicateKeyUpdate() {
        SQLInsertClause clause = this.queryFactory.insertOnDuplicateKeyUpdate((RelationalPath)QSurvey.survey, "c = c+1");
        Assert.assertEquals((Object)"insert into SURVEY\nvalues () on duplicate key update c = c+1", (Object)clause.toString());
    }

    @Test
    public void insertOnDuplicateKeyUpdate2() {
        SQLInsertClause clause = this.queryFactory.insertOnDuplicateKeyUpdate((RelationalPath)QSurvey.survey, (Expression)QSurvey.survey.id.eq((Object)2));
        Assert.assertEquals((Object)"insert into SURVEY\nvalues () on duplicate key update SURVEY.ID = ?", (Object)clause.toString());
    }

    @Test
    public void insertOnDuplicateKeyUpdate_multiple() {
        SQLInsertClause clause = this.queryFactory.insertOnDuplicateKeyUpdate((RelationalPath)QSurvey.survey, new Expression[]{SQLExpressions.set(QSurvey.survey.id, (Object)2), SQLExpressions.set((Path)QSurvey.survey.name, (Object)"B")});
        Assert.assertEquals((Object)"insert into SURVEY\nvalues () on duplicate key update SURVEY.ID = ?, SURVEY.NAME = ?", (Object)clause.toString());
    }

    @Test
    public void insertOnDuplicateKeyUpdate_values() {
        SQLInsertClause clause = this.queryFactory.insertOnDuplicateKeyUpdate((RelationalPath)QSurvey.survey, SQLExpressions.set((Path)QSurvey.survey.name, (Expression)QSurvey.survey.name));
        Assert.assertEquals((Object)"insert into SURVEY\nvalues () on duplicate key update SURVEY.NAME = values(SURVEY.NAME)", (Object)clause.toString());
    }

    @Test
    public void insertOnDuplicateKeyUpdate_null() {
        SQLInsertClause clause = this.queryFactory.insertOnDuplicateKeyUpdate((RelationalPath)QSurvey.survey, SQLExpressions.set((Path)QSurvey.survey.name, (Object)null));
        Assert.assertEquals((Object)"insert into SURVEY\nvalues () on duplicate key update SURVEY.NAME = null", (Object)clause.toString());
    }

    @Test
    public void replace() {
        Assert.assertNotNull((Object)this.queryFactory.replace((RelationalPath)QSurvey.survey));
    }

    @Test
    public void update() {
        Assert.assertNotNull((Object)this.queryFactory.update((RelationalPath)QSurvey.survey));
    }

    @Test
    public void merge() {
        Assert.assertNotNull((Object)this.queryFactory.merge((RelationalPath)QSurvey.survey));
    }
}

