/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.mysql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.domain.QSurvey;
import com.querydsl.sql.mysql.MySQLQuery;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySQLQueryTest {
    private MySQLQuery<?> query;
    private QSurvey survey = new QSurvey("survey");

    @Before
    public void setUp() {
        this.query = new MySQLQuery(null, MySQLTemplates.builder().newLineToSingleSpace().build());
        this.query.from((Expression)this.survey);
        this.query.orderBy(this.survey.name.asc());
        this.query.getMetadata().setProjection((Expression)this.survey.name);
    }

    @Test
    public void syntax() {
        this.query.highPriority();
        this.query.straightJoin();
        this.query.smallResult();
        this.query.bigResult();
        this.query.bufferResult();
        this.query.cache();
        this.query.noCache();
        this.query.calcFoundRows();
        this.query.from((Expression)new QSurvey("survey2"));
        this.query.where((Predicate)this.survey.id.isNotNull());
        this.query.groupBy((Expression)this.survey.name);
        this.query.withRollup();
        this.query.having((Predicate)this.survey.name.isNull());
        this.query.orderBy(this.survey.name.asc());
        this.query.limit(2L);
        this.query.offset(3L);
        this.query.forUpdate();
        this.query.lockInShareMode();
    }

    @Test
    public void forceIndex() {
        this.query = new MySQLQuery(null, MySQLTemplates.builder().newLineToSingleSpace().build());
        this.query.from((Expression)this.survey);
        this.query.forceIndex(new String[]{"col1_index"});
        this.query.orderBy(this.survey.name.asc());
        this.query.getMetadata().setProjection((Expression)this.survey.name);
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey force index (col1_index) order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void ignoreIndex() {
        this.query = new MySQLQuery(null, MySQLTemplates.builder().newLineToSingleSpace().build());
        this.query.from((Expression)this.survey);
        this.query.ignoreIndex(new String[]{"col1_index"});
        this.query.orderBy(this.survey.name.asc());
        this.query.getMetadata().setProjection((Expression)this.survey.name);
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey ignore index (col1_index) order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void useIndex() {
        this.query = new MySQLQuery(null, MySQLTemplates.builder().newLineToSingleSpace().build());
        this.query.from((Expression)this.survey);
        this.query.useIndex(new String[]{"col1_index"});
        this.query.orderBy(this.survey.name.asc());
        this.query.getMetadata().setProjection((Expression)this.survey.name);
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey use index (col1_index) order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void useIndex2() {
        this.query = new MySQLQuery(null, MySQLTemplates.builder().newLineToSingleSpace().build());
        this.query.from((Expression)this.survey);
        this.query.useIndex(new String[]{"col1_index", "col2_index"});
        this.query.orderBy(this.survey.name.asc());
        this.query.getMetadata().setProjection((Expression)this.survey.name);
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey use index (col1_index, col2_index) order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void highPriority() {
        this.query.highPriority();
        Assert.assertEquals((Object)"select high_priority survey.NAME from SURVEY survey order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void straightJoin() {
        this.query.straightJoin();
        Assert.assertEquals((Object)"select straight_join survey.NAME from SURVEY survey order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void smallResult() {
        this.query.smallResult();
        Assert.assertEquals((Object)"select sql_small_result survey.NAME from SURVEY survey order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void bigResult() {
        this.query.bigResult();
        Assert.assertEquals((Object)"select sql_big_result survey.NAME from SURVEY survey order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void bufferResult() {
        this.query.bufferResult();
        Assert.assertEquals((Object)"select sql_buffer_result survey.NAME from SURVEY survey order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void cache() {
        this.query.cache();
        Assert.assertEquals((Object)"select sql_cache survey.NAME from SURVEY survey order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void noCache() {
        this.query.noCache();
        Assert.assertEquals((Object)"select sql_no_cache survey.NAME from SURVEY survey order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void calcFoundRows() {
        this.query.calcFoundRows();
        Assert.assertEquals((Object)"select sql_calc_found_rows survey.NAME from SURVEY survey order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void withRollup() {
        this.query.groupBy((Expression)this.survey.name);
        this.query.withRollup();
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey group by survey.NAME with rollup  order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void forUpdate() {
        this.query.forUpdate();
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey order by survey.NAME asc for update", (Object)this.toString(this.query));
    }

    @Test
    public void forUpdate_with_limit() {
        this.query.forUpdate();
        this.query.limit(2L);
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey order by survey.NAME asc limit ? for update", (Object)this.toString(this.query));
    }

    @Test
    public void intoOutfile() {
        this.query.intoOutfile(new File("target/out"));
        Assert.assertEquals((Object)("select survey.NAME from SURVEY survey order by survey.NAME asc into outfile 'target" + File.separator + "out'"), (Object)this.toString(this.query));
    }

    @Test
    public void intoDumpfile() {
        this.query.intoDumpfile(new File("target/out"));
        Assert.assertEquals((Object)("select survey.NAME from SURVEY survey order by survey.NAME asc into dumpfile 'target" + File.separator + "out'"), (Object)this.toString(this.query));
    }

    @Test
    public void intoString() {
        this.query.into("var1");
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey order by survey.NAME asc into var1", (Object)this.toString(this.query));
    }

    @Test
    public void lockInShareMode() {
        this.query.lockInShareMode();
        Assert.assertEquals((Object)"select survey.NAME from SURVEY survey order by survey.NAME asc lock in share mode", (Object)this.toString(this.query));
    }

    private String toString(MySQLQuery<?> query) {
        return query.toString().replace('\n', ' ');
    }
}

