/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.oracle;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.OracleTemplates;
import com.querydsl.sql.domain.QSurvey;
import com.querydsl.sql.oracle.OracleGrammar;
import com.querydsl.sql.oracle.OracleQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OracleQueryTest {
    private OracleQuery<?> query;
    private QSurvey survey = new QSurvey("survey");

    @Before
    public void setUp() {
        this.query = new OracleQuery(null, OracleTemplates.builder().newLineToSingleSpace().build());
        this.query.from((Expression)this.survey);
        this.query.orderBy(this.survey.name.asc());
    }

    @Test
    public void connectByPrior() {
        this.query.connectByPrior((Predicate)this.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY survey connect by prior survey.NAME is null order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void connectBy() {
        this.query.connectByPrior((Predicate)this.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY survey connect by prior survey.NAME is null order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void connectByNocyclePrior() {
        this.query.connectByNocyclePrior((Predicate)this.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY survey connect by nocycle prior survey.NAME is null order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void startWith() {
        this.query.startWith((Predicate)this.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY survey start with survey.NAME is null order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void orderSiblingsBy() {
        this.query.orderSiblingsBy((Expression)this.survey.name);
        Assert.assertEquals((Object)"from SURVEY survey order siblings by survey.NAME order by survey.NAME asc", (Object)this.toString(this.query));
    }

    @Test
    public void rowNum() {
        this.query.where((Predicate)OracleGrammar.rownum.lt((Number)5));
        Assert.assertEquals((Object)"from SURVEY survey where rownum < ? order by survey.NAME asc", (Object)this.toString(this.query));
    }

    private String toString(OracleQuery query) {
        return query.toString().replace('\n', ' ');
    }
}

