/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.postgresql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QSurvey;
import com.querydsl.sql.postgresql.PostgreSQLQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PostgreSQLQueryTest {
    private PostgreSQLQuery<?> query;
    private QSurvey survey = new QSurvey("survey");
    private QEmployee employee = new QEmployee("employee");

    @Before
    public void setUp() {
        this.query = new PostgreSQLQuery(null, PostgreSQLTemplates.builder().newLineToSingleSpace().build());
    }

    @Test
    public void syntax() {
        this.query.distinctOn(new Expression[]{this.survey.name});
        this.query.from((Expression)this.survey);
        this.query.where((Predicate)this.survey.name.isNull());
        this.query.groupBy((Expression)this.survey.name);
        this.query.having((Predicate)this.survey.id.isNotNull());
        this.query.orderBy(this.survey.name.asc());
        this.query.limit(4L);
        this.query.offset(4L);
        this.query.forUpdate();
        this.query.forShare();
        this.query.noWait();
        ((PostgreSQLQuery)this.query.forUpdate()).of(new RelationalPath[]{this.survey});
    }

    @Test
    public void forShare() {
        ((PostgreSQLQuery)this.query.from((Expression)this.survey)).forShare();
        Assert.assertEquals((Object)"from SURVEY survey for share", (Object)this.toString(this.query));
    }

    @Test
    public void forUpDate_noWait() {
        ((PostgreSQLQuery)((PostgreSQLQuery)this.query.from((Expression)this.survey)).forUpdate()).noWait();
        Assert.assertEquals((Object)"from SURVEY survey for update nowait", (Object)this.toString(this.query));
    }

    @Test
    public void forUpdate_of() {
        ((PostgreSQLQuery)((PostgreSQLQuery)this.query.from((Expression)this.survey)).forUpdate()).of(new RelationalPath[]{this.survey});
        Assert.assertEquals((Object)"from SURVEY survey for update of SURVEY", (Object)this.toString(this.query));
    }

    @Test
    public void distinct_on() {
        ((PostgreSQLQuery)((PostgreSQLQuery)((PostgreSQLQuery)this.query.from((Expression)this.employee)).distinctOn(new Expression[]{this.employee.datefield, this.employee.timefield})).orderBy(new OrderSpecifier[]{this.employee.datefield.asc(), this.employee.timefield.asc(), this.employee.salary.asc()})).select(this.employee.id);
        Assert.assertEquals((Object)"select distinct on(employee.DATEFIELD, employee.TIMEFIELD) employee.ID from EMPLOYEE employee order by employee.DATEFIELD asc, employee.TIMEFIELD asc, employee.SALARY asc", (Object)this.toString(this.query));
    }

    private String toString(PostgreSQLQuery query) {
        return query.toString().replace('\n', ' ');
    }
}

