/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.suites;

import com.querydsl.core.QueryException;
import com.querydsl.core.dml.DMLClause;
import com.querydsl.core.testutil.H2;
import com.querydsl.core.types.Path;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Connections;
import com.querydsl.sql.DefaultSQLExceptionTranslator;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExceptionTranslator;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import com.querydsl.sql.domain.QSurvey;
import java.sql.SQLException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={H2.class})
public class H2ExceptionSuiteTest
extends AbstractBaseTest {
    private static final SQLExceptionTranslator exceptionTranslator = DefaultSQLExceptionTranslator.DEFAULT;

    @BeforeClass
    public static void setUp() throws Exception {
        Connections.initH2();
        Connections.initConfiguration(H2Templates.builder().build());
        Connections.getConnection().createStatement().execute("ALTER TABLE SURVEY ADD CONSTRAINT UNIQUE_ID UNIQUE(ID)");
    }

    public static void tearDown() throws Exception {
        Connections.getConnection().createStatement().execute("ALTER TABLE SURVEY DROP CONSTRAINT UNIQUE_ID");
    }

    @Test
    public void sQLExceptionCreationTranslated() {
        SQLException e1 = new SQLException("Exception #1", "42001", 181);
        SQLException e2 = new SQLException("Exception #2", "HY000", 1030);
        e1.setNextException(e2);
        SQLException sqlException = new SQLException("Batch operation failed");
        sqlException.setNextException(e1);
        RuntimeException result = exceptionTranslator.translate(sqlException);
        this.inspectExceptionResult(result);
    }

    @Test
    public void updateBatchFailed() {
        this.execute(new DMLClause[]{((SQLInsertClause)this.insert((RelationalPath<?>)QSurvey.survey).columns(new Path[]{QSurvey.survey.name, QSurvey.survey.name2})).values(new Object[]{"New Survey", "New Survey"})});
        QueryException result = null;
        try {
            this.execute(new DMLClause[]{((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)QSurvey.survey).set(QSurvey.survey.id, (Object)1)).addBatch()).set(QSurvey.survey.id, (Object)2)).addBatch()});
        }
        catch (QueryException e) {
            result = e;
        }
        Assert.assertNotNull((Object)((Object)result));
        this.inspectExceptionResult((Exception)((Object)result));
    }

    private void inspectExceptionResult(Exception result) {
        Assert.assertThat((Object)result.getSuppressed(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyArray())));
    }
}

