/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.teradata;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.teradata.SetQueryBandClause;
import java.sql.Connection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SetQueryBandClauseTest {
    private Configuration conf;
    private SetQueryBandClause clause;

    @Before
    public void setUp() {
        this.conf = new Configuration(SQLTemplates.DEFAULT);
        this.conf.setUseLiterals(true);
        this.clause = new SetQueryBandClause((Connection)null, this.conf);
    }

    @Test
    public void toString_() {
        this.clause.set("a", "b");
        Assert.assertEquals((Object)"set query_band='a=b;' for session", (Object)this.clause.toString());
    }

    @Test
    public void toString2() {
        this.conf.setUseLiterals(false);
        this.clause.set("a", "b");
        this.clause.forTransaction();
        Assert.assertEquals((Object)"set query_band=? for transaction", (Object)this.clause.toString());
    }

    @Test
    public void forTransaction() {
        this.clause.forTransaction();
        this.clause.set("a", "b");
        this.clause.set("b", "c");
        Assert.assertEquals((Object)"set query_band='a=b;b=c;' for transaction", (Object)this.clause.toString());
    }

    @Test
    public void getSQL() {
        this.clause.forTransaction();
        this.clause.set("a", "b");
        this.clause.set("b", "c");
        Assert.assertEquals((Object)"set query_band='a=b;b=c;' for transaction", (Object)((SQLBindings)this.clause.getSQL().get(0)).getSQL());
    }
}

