/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.types;

import com.querydsl.sql.types.ArrayType;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ArrayTypeTest {
    @Test
    public void set_object_array() throws SQLException {
        Object[] value = new Integer[]{1, 2, 3};
        ArrayType type = new ArrayType(Integer[].class, "INTEGER ARRAY");
        Array arr = (Array)EasyMock.createMock(Array.class);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        PreparedStatement stmt = (PreparedStatement)EasyMock.createMock(PreparedStatement.class);
        EasyMock.expect((Object)stmt.getConnection()).andStubReturn((Object)conn);
        EasyMock.expect((Object)conn.createArrayOf("INTEGER ARRAY", value)).andReturn((Object)arr);
        stmt.setArray(1, arr);
        EasyMock.replay((Object[])new Object[]{arr, conn, stmt});
        type.setValue(stmt, 1, (Object)value);
        EasyMock.verify((Object[])new Object[]{arr, conn, stmt});
    }

    @Test
    public void set_primitive_array() throws SQLException {
        int[] value = new int[]{1, 2, 3};
        Object[] boxedValue = new Integer[]{1, 2, 3};
        ArrayType type = new ArrayType(int[].class, "INTEGER ARRAY");
        Array arr = (Array)EasyMock.createMock(Array.class);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        PreparedStatement stmt = (PreparedStatement)EasyMock.createMock(PreparedStatement.class);
        EasyMock.expect((Object)stmt.getConnection()).andStubReturn((Object)conn);
        EasyMock.expect((Object)conn.createArrayOf("INTEGER ARRAY", boxedValue)).andReturn((Object)arr);
        stmt.setArray(1, arr);
        EasyMock.replay((Object[])new Object[]{arr, conn, stmt});
        type.setValue(stmt, 1, (Object)value);
        EasyMock.verify((Object[])new Object[]{arr, conn, stmt});
    }

    @Test
    public void get_typed_object_array() throws SQLException {
        Integer[] value = new Integer[]{1, 2, 3};
        ArrayType type = new ArrayType(Integer[].class, "INTEGER ARRAY");
        ResultSet rs = (ResultSet)EasyMock.createMock(ResultSet.class);
        Array arr = (Array)EasyMock.createMock(Array.class);
        EasyMock.expect((Object)rs.getArray(1)).andReturn((Object)arr);
        EasyMock.expect((Object)arr.getArray()).andReturn((Object)value);
        EasyMock.replay((Object[])new Object[]{rs, arr});
        Integer[] result = (Integer[])type.getValue(rs, 1);
        Assert.assertSame((Object)value, (Object)result);
        EasyMock.verify((Object[])new Object[]{rs, arr});
    }

    @Test
    public void get_generic_object_array() throws SQLException {
        Object[] value = new Object[]{1, 2, 3};
        ArrayType type = new ArrayType(Integer[].class, "INTEGER ARRAY");
        ResultSet rs = (ResultSet)EasyMock.createMock(ResultSet.class);
        Array arr = (Array)EasyMock.createMock(Array.class);
        EasyMock.expect((Object)rs.getArray(1)).andReturn((Object)arr);
        EasyMock.expect((Object)arr.getArray()).andReturn((Object)value);
        EasyMock.replay((Object[])new Object[]{rs, arr});
        Object[] result = (Integer[])type.getValue(rs, 1);
        Assert.assertArrayEquals((Object[])value, (Object[])result);
        EasyMock.verify((Object[])new Object[]{rs, arr});
    }

    @Test
    public void get_primitive_array() throws SQLException {
        int[] value = new int[]{1, 2, 3};
        Object[] boxedValue = new Integer[]{1, 2, 3};
        ArrayType type = new ArrayType(Integer[].class, "INTEGER ARRAY");
        ResultSet rs = (ResultSet)EasyMock.createMock(ResultSet.class);
        Array arr = (Array)EasyMock.createMock(Array.class);
        EasyMock.expect((Object)rs.getArray(1)).andReturn((Object)arr);
        EasyMock.expect((Object)arr.getArray()).andReturn((Object)value);
        EasyMock.replay((Object[])new Object[]{rs, arr});
        Object[] result = (Integer[])type.getValue(rs, 1);
        Assert.assertArrayEquals((Object[])boxedValue, (Object[])result);
        EasyMock.verify((Object[])new Object[]{rs, arr});
    }
}

