/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.types;

import com.mysema.commons.lang.Pair;
import com.querydsl.sql.types.BigDecimalAsDoubleType;
import com.querydsl.sql.types.BigDecimalType;
import com.querydsl.sql.types.BigIntegerAsLongType;
import com.querydsl.sql.types.BigIntegerType;
import com.querydsl.sql.types.BlobType;
import com.querydsl.sql.types.ByteType;
import com.querydsl.sql.types.BytesType;
import com.querydsl.sql.types.CalendarType;
import com.querydsl.sql.types.CharacterType;
import com.querydsl.sql.types.ClobType;
import com.querydsl.sql.types.CurrencyType;
import com.querydsl.sql.types.DateTimeType;
import com.querydsl.sql.types.DateType;
import com.querydsl.sql.types.DoubleType;
import com.querydsl.sql.types.EnumByNameType;
import com.querydsl.sql.types.EnumByOrdinalType;
import com.querydsl.sql.types.FloatType;
import com.querydsl.sql.types.IntegerType;
import com.querydsl.sql.types.LocalDateTimeType;
import com.querydsl.sql.types.LocalDateType;
import com.querydsl.sql.types.LocalTimeType;
import com.querydsl.sql.types.LongType;
import com.querydsl.sql.types.NumericBooleanType;
import com.querydsl.sql.types.ObjectType;
import com.querydsl.sql.types.ShortType;
import com.querydsl.sql.types.StringType;
import com.querydsl.sql.types.TimeType;
import com.querydsl.sql.types.TimestampType;
import com.querydsl.sql.types.TrueFalseType;
import com.querydsl.sql.types.Type;
import com.querydsl.sql.types.URLType;
import com.querydsl.sql.types.UtilDateType;
import com.querydsl.sql.types.UtilUUIDType;
import com.querydsl.sql.types.YesNoType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.UUID;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.junit.Assert;
import org.junit.Test;

public class TypeTest
implements InvocationHandler {
    private Object value;
    private final ResultSet resultSet = (ResultSet)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)this);
    private final PreparedStatement statement = (PreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)this);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("wasNull")) {
            return this.value == null;
        }
        if (method.getName().startsWith("get")) {
            if (method.getReturnType().isPrimitive() && this.value == null) {
                Class<?> rt = method.getReturnType();
                if (rt == Byte.TYPE) {
                    return (byte)0;
                }
                if (rt == Short.TYPE) {
                    return (short)0;
                }
                if (rt == Integer.TYPE) {
                    return 0;
                }
                if (rt == Long.TYPE) {
                    return 0L;
                }
                if (rt == Float.TYPE) {
                    return Float.valueOf(0.0f);
                }
                if (rt == Double.TYPE) {
                    return 0.0;
                }
                if (rt == Boolean.TYPE) {
                    return Boolean.FALSE;
                }
                if (rt == Character.TYPE) {
                    return Character.valueOf('\u0000');
                }
            }
            return this.value;
        }
        this.value = args[1];
        return null;
    }

    @Test
    public void test() throws MalformedURLException, SQLException {
        ArrayList<Pair> valueAndType = new ArrayList<Pair>();
        valueAndType.add(Pair.of((Object)new BigDecimal("1"), (Object)new BigDecimalType()));
        valueAndType.add(Pair.of((Object)new BigInteger("2"), (Object)new BigIntegerType()));
        valueAndType.add(Pair.of((Object)new BigDecimal("1.0"), (Object)new BigDecimalAsDoubleType()));
        valueAndType.add(Pair.of((Object)new BigInteger("2"), (Object)new BigIntegerAsLongType()));
        valueAndType.add(Pair.of((Object)1, (Object)new ByteType()));
        valueAndType.add(Pair.of((Object)new byte[0], (Object)new BytesType()));
        valueAndType.add(Pair.of((Object)Calendar.getInstance(), (Object)new CalendarType()));
        valueAndType.add(Pair.of((Object)Character.valueOf('c'), (Object)new CharacterType()));
        valueAndType.add(Pair.of((Object)Currency.getInstance("EUR"), (Object)new CurrencyType()));
        valueAndType.add(Pair.of((Object)new Date(0L), (Object)new DateType()));
        valueAndType.add(Pair.of((Object)1.0, (Object)new DoubleType()));
        valueAndType.add(Pair.of((Object)Float.valueOf(1.0f), (Object)new FloatType()));
        valueAndType.add(Pair.of((Object)1, (Object)new IntegerType()));
        valueAndType.add(Pair.of((Object)true, (Object)new NumericBooleanType()));
        valueAndType.add(Pair.of((Object)1L, (Object)new LongType()));
        valueAndType.add(Pair.of((Object)new Object(), (Object)new ObjectType()));
        valueAndType.add(Pair.of((Object)1, (Object)new ShortType()));
        valueAndType.add(Pair.of((Object)"", (Object)new StringType()));
        valueAndType.add(Pair.of((Object)true, (Object)new TrueFalseType()));
        valueAndType.add(Pair.of((Object)true, (Object)new YesNoType()));
        valueAndType.add(Pair.of((Object)new Timestamp(0L), (Object)new TimestampType()));
        valueAndType.add(Pair.of((Object)new Time(0L), (Object)new TimeType()));
        valueAndType.add(Pair.of((Object)new URL("http://www.mysema.com"), (Object)new URLType()));
        valueAndType.add(Pair.of((Object)new java.util.Date(), (Object)new UtilDateType()));
        valueAndType.add(Pair.of((Object)new DateTime(), (Object)new DateTimeType()));
        valueAndType.add(Pair.of((Object)new LocalDateTime(), (Object)new LocalDateTimeType()));
        valueAndType.add(Pair.of((Object)new LocalDate(), (Object)new LocalDateType()));
        valueAndType.add(Pair.of((Object)new LocalTime(), (Object)new LocalTimeType()));
        valueAndType.add(Pair.of((Object)((Object)Gender.MALE), (Object)new EnumByNameType(Gender.class)));
        valueAndType.add(Pair.of((Object)((Object)Gender.MALE), (Object)new EnumByOrdinalType(Gender.class)));
        valueAndType.add(Pair.of((Object)EasyMock.createNiceMock(Blob.class), (Object)new BlobType()));
        valueAndType.add(Pair.of((Object)EasyMock.createNiceMock(Clob.class), (Object)new ClobType()));
        valueAndType.add(Pair.of((Object)UUID.randomUUID(), (Object)new UtilUUIDType(true)));
        valueAndType.add(Pair.of((Object)UUID.randomUUID(), (Object)new UtilUUIDType(false)));
        for (Pair pair : valueAndType) {
            this.value = null;
            Type type = (Type)pair.getSecond();
            Assert.assertNull((String)type.toString(), (Object)type.getValue(this.resultSet, 0));
            type.setValue(this.statement, 0, pair.getFirst());
            Assert.assertEquals((String)type.toString(), (Object)pair.getFirst(), (Object)type.getValue(this.resultSet, 0));
        }
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }
}

