/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.jcabi.log.Logger;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.qulice.spi.Environment;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class CheckstyleListener
implements AuditListener {
    private final Environment env;
    private final List<AuditEvent> all = new LinkedList<AuditEvent>();

    CheckstyleListener(Environment environ) {
        this.env = environ;
    }

    public List<AuditEvent> events() {
        return Collections.unmodifiableList(this.all);
    }

    public void auditStarted(AuditEvent event) {
    }

    public void auditFinished(AuditEvent event) {
    }

    public void fileStarted(AuditEvent event) {
    }

    public void fileFinished(AuditEvent event) {
    }

    public void addError(AuditEvent event) {
        String name = event.getFileName().substring(this.env.basedir().toString().length());
        if (!this.env.exclude("checkstyle", name)) {
            this.all.add(event);
        }
    }

    public void addException(AuditEvent event, Throwable throwable) {
        String check = event.getSourceName();
        Logger.error((Object)this, (String)"%s[%d]: %s (%s), %[exception]s", (Object[])new Object[]{event.getFileName().substring(this.env.basedir().toString().length()), event.getLine(), event.getMessage(), check.substring(check.lastIndexOf(46) + 1), throwable});
    }
}

