/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.google.common.collect.Lists;
import com.jcabi.log.Logger;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.qulice.checkstyle.CheckstyleListener;
import com.qulice.spi.Environment;
import com.qulice.spi.ResourceValidator;
import com.qulice.spi.Violation;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.cactoos.Text;
import org.cactoos.text.Replaced;
import org.cactoos.text.TextOf;
import org.cactoos.text.Trimmed;
import org.xml.sax.InputSource;

public final class CheckstyleValidator
implements ResourceValidator {
    private final Checker checker = new Checker();
    private final CheckstyleListener listener;

    public CheckstyleValidator(Environment env) {
        this.checker.setClassLoader(env.classloader());
        this.checker.setModuleClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            this.checker.configure(this.configuration(env));
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException("Failed to configure checker", ex);
        }
        this.listener = new CheckstyleListener(env);
        this.checker.addListener((AuditListener)this.listener);
    }

    public Collection<Violation> validate(Collection<File> files) {
        try {
            this.checker.process((List)Lists.newArrayList(files));
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException("Failed to process files", ex);
        }
        List<AuditEvent> events = this.listener.events();
        LinkedList<Violation> results = new LinkedList<Violation>();
        for (AuditEvent event : events) {
            String check = event.getSourceName();
            results.add((Violation)new Violation.Default(this.name(), check.substring(check.lastIndexOf(46) + 1), event.getFileName(), String.valueOf(event.getLine()), event.getMessage()));
        }
        return results;
    }

    public String name() {
        return "Checkstyle";
    }

    private Configuration configuration(Environment env) {
        Configuration config;
        File cache = new File(env.tempdir(), "checkstyle/checkstyle.cache");
        File parent = cache.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalStateException(String.format("Unable to create directories needed for %s", cache.getPath()));
        }
        Properties props = new Properties();
        props.setProperty("cache.file", cache.getPath());
        props.setProperty("header", this.header(env));
        InputSource src = new InputSource(this.getClass().getResourceAsStream("checks.xml"));
        try {
            config = ConfigurationLoader.loadConfiguration((InputSource)src, (PropertyResolver)new PropertiesExpander(props), (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.OMIT);
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException("Failed to load config", ex);
        }
        return config;
    }

    private String header(Environment env) {
        String content;
        String name = env.param("license", "LICENSE.txt");
        URL url = CheckstyleValidator.toUrl(env, name);
        try {
            content = new Replaced((Text)new Trimmed((Text)new TextOf(url.openStream())), "[\\r\\n]+$", "").asString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read license", ex);
        }
        StringBuilder builder = new StringBuilder(100);
        String eol = System.getProperty("line.separator");
        builder.append("/*").append(eol);
        for (String line : StringUtils.splitPreserveAllTokens((String)content, (String)eol)) {
            builder.append(" *");
            if (!line.trim().isEmpty()) {
                builder.append(' ').append(line.trim());
            }
            builder.append(eol);
        }
        builder.append(" */");
        String license = builder.toString();
        Logger.debug((Object)this, (String)"LICENSE found: %s", (Object[])new Object[]{url});
        Logger.debug((Object)this, (String)"LICENSE full text after parsing:\n%s", (Object[])new Object[]{license});
        return license;
    }

    private static URL toUrl(Environment env, String name) {
        URL url;
        if (name.startsWith("file:")) {
            try {
                url = new URL(name);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Invalid URL", ex);
            }
        } else {
            url = env.classloader().getResource(name);
            if (url == null) {
                throw new IllegalStateException(String.format("'%s' resource is not found in classpath", name));
            }
        }
        return url;
    }
}

