/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;

public final class CurlyBracketsStructureCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return new int[]{29};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 29) {
            this.checkParams(ast);
        }
    }

    private void checkParams(DetailAST node) {
        DetailAST closing = node.findFirstToken(73);
        if (closing != null) {
            this.checkLines(node, node.getLineNo(), closing.getLineNo());
        }
    }

    private void checkLines(DetailAST node, int start, int end) {
        if (start != end) {
            this.checkExpressions(CurlyBracketsStructureCheck.findAllChildren(node, 28), start, end);
        }
    }

    private void checkExpressions(Iterable<DetailAST> exprs, int start, int end) {
        for (DetailAST expr : exprs) {
            DetailAST last;
            int lline;
            int pline = expr.getLineNo();
            if (pline == start) {
                this.log(pline, "Parameters should start on a new line", new Object[0]);
            }
            if ((lline = (last = expr.getLastChild()).getLineNo()) != end) continue;
            this.log(lline, "Closing bracket should be on a new line", new Object[0]);
        }
    }

    private static Iterable<DetailAST> findAllChildren(DetailAST base, int type) {
        ArrayList children = Lists.newArrayList();
        for (DetailAST child = base.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != type) continue;
            children.add(child);
        }
        return children;
    }
}

