/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.qulice.checkstyle.LineRange;
import com.qulice.checkstyle.LineRanges;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;

public final class EmptyLinesCheck
extends AbstractCheck {
    private static final Pattern PATTERN = Pattern.compile("^\\s*$");
    private final LineRanges anons = new LineRanges();
    private final LineRanges methods = new LineRanges();

    public int[] getDefaultTokens() {
        return new int[]{9, 8, 6};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        DetailAST opening;
        this.getLine(ast.getLastChild().getLine());
        if (ast.getType() == 6 && ast.getParent() != null && ast.getParent().getType() == 136) {
            DetailAST left = ast.getFirstChild();
            DetailAST right = ast.getLastChild();
            if (left != null && right != null) {
                this.anons.add(new LineRange(left.getLineNo(), right.getLineNo()));
            }
        } else if ((ast.getType() == 9 || ast.getType() == 8) && (opening = ast.findFirstToken(7)) != null) {
            DetailAST right = opening.findFirstToken(73);
            this.methods.add(new LineRange(opening.getLineNo(), right.getLineNo()));
        }
    }

    public void finishTree(DetailAST root) {
        String[] lines = this.getLines();
        for (int line = 0; line < lines.length; ++line) {
            if (!this.methods.inRange(line + 1) || !PATTERN.matcher(lines[line]).find() || !this.insideMethod(line + 1)) continue;
            this.log(line + 1, "Empty line inside method", new Object[0]);
        }
        this.methods.clear();
        this.anons.clear();
        super.finishTree(root);
    }

    private boolean insideMethod(int line) {
        int method = EmptyLinesCheck.linesBetweenBraces(line, this.methods::iterator, Integer.MIN_VALUE);
        int clazz = EmptyLinesCheck.linesBetweenBraces(line, this.anons::iterator, Integer.MAX_VALUE);
        return method < clazz;
    }

    private static int linesBetweenBraces(int line, Iterable<LineRange> iterator, int def) {
        return StreamSupport.stream(iterator.spliterator(), false).filter(r -> r.within(line)).min(Comparator.comparingInt(r -> r.last() - r.first())).map(r -> r.last() - r.first()).orElse(def);
    }
}

