/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;

public final class ImportCohesionCheck
extends AbstractFileSetCheck {
    private static final String IMPORT = "import ";

    public void processFiltered(File file, FileText lines) {
        int first = -1;
        int last = -1;
        for (int pos = 0; pos < lines.size(); ++pos) {
            String line = lines.get(pos);
            if (!line.startsWith(IMPORT)) continue;
            if (first == -1) {
                first = pos;
            }
            last = pos;
        }
        if (first == -1) {
            return;
        }
        if (this.check(first, last, lines)) {
            this.fireErrors(file.getPath());
        }
    }

    private boolean check(int first, int last, FileText lines) {
        boolean failure = false;
        if (first == 0 || !lines.get(first - 1).isEmpty()) {
            this.log(first, "Line before imports should be empty", new Object[0]);
            failure = true;
        }
        if (lines.size() > last + 1 && !lines.get(last + 1).isEmpty()) {
            this.log(last + 2, "Line after imports should be empty", new Object[0]);
            failure = true;
        }
        for (int pos = first; pos < last; ++pos) {
            String line = lines.get(pos);
            if (line.startsWith(IMPORT)) continue;
            this.log(pos + 1, "Empty line or comment between imports is not allowed", new Object[0]);
            failure = true;
        }
        return failure;
    }
}

