/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.qulice.checkstyle.parameters.Arguments;
import com.qulice.checkstyle.parameters.TypeParameters;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavadocParameterOrderCheck
extends AbstractCheck {
    private static final Pattern MATCH_JAVADOC_ARG = Pattern.compile("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(param)\\s+(\\S+)\\s+\\S*");
    private static final Pattern MATCH_JAVADOC_ARG_MULTILINE_START = Pattern.compile("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(param)\\s+(\\S+)\\s*$");
    private static final Pattern MATCH_JAVADOC_MULTILINE_CONT = Pattern.compile("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";

    public int[] getDefaultTokens() {
        return new int[]{15, 14, 8, 9};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        FileContents contents = this.getFileContents();
        TextBlock doc = contents.getJavadocBefore(ast.getLineNo());
        if (doc != null) {
            this.checkParameters(ast, doc);
        }
    }

    private static List<JavadocTag> getMethodTags(TextBlock comment) {
        String[] lines = comment.getText();
        LinkedList<JavadocTag> tags = new LinkedList<JavadocTag>();
        int current = comment.getStartLineNo() - 1;
        int start = comment.getStartColNo();
        for (int line = 0; line < lines.length; ++line) {
            int col;
            ++current;
            Matcher docmatcher = MATCH_JAVADOC_ARG.matcher(lines[line]);
            Matcher multiline = MATCH_JAVADOC_ARG_MULTILINE_START.matcher(lines[line]);
            if (docmatcher.find()) {
                col = JavadocParameterOrderCheck.calculateTagColumn(docmatcher, line, start);
                tags.add(new JavadocTag(current, col, docmatcher.group(1), docmatcher.group(2)));
                continue;
            }
            if (!multiline.find()) continue;
            col = JavadocParameterOrderCheck.calculateTagColumn(multiline, line, start);
            tags.addAll(JavadocParameterOrderCheck.getMultilineArgTags(multiline, col, lines, line, current));
        }
        return tags;
    }

    private static int calculateTagColumn(Matcher matcher, int line, int start) {
        int col = matcher.start(1) - 1;
        if (line == 0) {
            col += start;
        }
        return col;
    }

    private static List<JavadocTag> getMultilineArgTags(Matcher matcher, int column, String[] lines, int index, int line) {
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>(0);
        String paramone = matcher.group(1);
        String paramtwo = matcher.group(2);
        for (int remindex = index + 1; remindex < lines.length; ++remindex) {
            Matcher multiline = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[remindex]);
            if (!multiline.find()) continue;
            remindex = lines.length;
            String lfin = multiline.group(1);
            if (lfin.equals(NEXT_TAG) || lfin.equals(END_JAVADOC)) continue;
            tags.add(new JavadocTag(line, column, paramone, paramtwo));
        }
        return tags;
    }

    private void checkParameters(DetailAST ast, TextBlock doc) {
        List<JavadocTag> tags = JavadocParameterOrderCheck.getMethodTags(doc);
        Arguments args = new Arguments(ast);
        TypeParameters types = new TypeParameters(ast);
        int count = args.count() + types.count();
        if (tags.size() == count) {
            Consumer<JavadocTag> logger = tag -> this.log(tag.getLineNo(), "Javadoc parameter order different than method signature", new Object[0]);
            args.checkOrder(tags, logger);
            types.checkOrder(tags, logger);
        } else {
            this.log(ast.getLineNo(), "Number of javadoc parameters different than method signature", new Object[0]);
        }
    }
}

