/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class MultilineJavadocTagsCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        String[] lines = this.getLines();
        int start = ast.getLineNo();
        int cstart = MultilineJavadocTagsCheck.findCommentStart(lines, start) + 1;
        int cend = MultilineJavadocTagsCheck.findCommentEnd(lines, start) - 1;
        if (cend >= cstart && cstart >= 0) {
            this.checkJavaDoc(lines, cstart, cend);
        } else {
            this.log(0, "Can't find method comment", new Object[0]);
        }
    }

    private void checkJavaDoc(String[] lines, int start, int end) {
        boolean tagged = false;
        int index = -1;
        for (int current = start; current <= end; ++current) {
            int text;
            String line = lines[current];
            if (line.contains("* @")) {
                tagged = true;
                index = line.indexOf(64);
                continue;
            }
            if (!tagged) continue;
            int comment = line.indexOf(42);
            for (text = comment + 1; text < line.length() && line.charAt(text) == ' '; ++text) {
            }
            if (text == index + 1) continue;
            this.log(current + 1, "Should contain one indentation space", new Object[0]);
        }
    }

    private static int findCommentStart(String[] lines, int start) {
        return MultilineJavadocTagsCheck.findTrimmedTextUp(lines, start, "/**");
    }

    private static int findCommentEnd(String[] lines, int start) {
        return MultilineJavadocTagsCheck.findTrimmedTextUp(lines, start, "*/");
    }

    private static int findTrimmedTextUp(String[] lines, int start, String text) {
        int found = -1;
        for (int pos = start - 1; pos >= 0; --pos) {
            if (!lines[pos].trim().equals(text)) continue;
            found = pos;
            break;
        }
        return found;
    }
}

