/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.regex.Pattern;

public final class NonStaticMethodCheck
extends AbstractCheck {
    private Pattern exclude = Pattern.compile("^$");

    public void setExcludeFileNamePattern(String excl) {
        this.exclude = Pattern.compile(excl);
    }

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (this.exclude.matcher(this.getFileContents().getFileName()).find()) {
            return;
        }
        if (14 == ast.getParent().getParent().getType()) {
            this.checkClassMethod(ast);
        }
    }

    private void checkClassMethod(DetailAST method) {
        boolean onlythrow;
        DetailAST modifiers = method.findFirstToken(5);
        if (modifiers.findFirstToken(64) != null) {
            return;
        }
        boolean bl = onlythrow = method.branchContains(90) && !method.branchContains(72) && this.countSemiColons(method) == 1;
        if (!(AnnotationUtil.containsAnnotation((DetailAST)method, (String)"Override") || NonStaticMethodCheck.isInAbstractOrNativeMethod(method) || method.branchContains(78) || onlythrow)) {
            int line = method.getLineNo();
            this.log(line, "This method must be static, because it does not refer to \"this\"", new Object[0]);
        }
    }

    private static boolean isInAbstractOrNativeMethod(DetailAST method) {
        DetailAST modifiers = method.findFirstToken(5);
        return modifiers.branchContains(40) || modifiers.branchContains(66);
    }

    private int countSemiColons(DetailAST method) {
        DetailAST openingbrace = method.findFirstToken(7);
        int count = 0;
        if (openingbrace != null) {
            DetailAST closingbrace = openingbrace.findFirstToken(73);
            int lastline = closingbrace.getLineNo();
            int firstline = openingbrace.getLineNo();
            FileContents contents = this.getFileContents();
            for (int line = firstline - 1; line < lastline; ++line) {
                if (contents.lineIsBlank(line) || contents.lineIsComment(line) || !contents.getLine(line).contains(";")) continue;
                ++count;
            }
        }
        return count;
    }
}

