/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import org.cactoos.Text;
import org.cactoos.text.Joined;
import org.cactoos.text.UncheckedText;

public final class ProhibitNonFinalClassesCheck
extends AbstractCheck {
    private static final String PACKAGE_SEPARATOR = ".";
    private Deque<ClassDesc> classes = new ArrayDeque<ClassDesc>();
    private String pack;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{14};
    }

    public void beginTree(DetailAST root) {
        this.classes = new ArrayDeque<ClassDesc>();
        this.pack = "";
    }

    public void visitToken(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (ast.getType() == 14) {
            boolean isfinal = modifiers.findFirstToken(39) != null;
            boolean isabstract = modifiers.findFirstToken(40) != null;
            String qualified = this.getQualifiedClassName(ast);
            this.classes.push(new ClassDesc(qualified, isfinal, isabstract));
        }
    }

    public void leaveToken(DetailAST ast) {
        ClassDesc desc;
        if (!(ast.getType() != 14 || (desc = this.classes.pop()).isDeclaredAsAbstract() || desc.isAsfinal() || ScopeUtil.isInInterfaceOrAnnotationBlock((DetailAST)ast))) {
            String qualified = desc.getQualified();
            String name = ProhibitNonFinalClassesCheck.getClassNameFromQualifiedName(qualified);
            this.log(ast.getLineNo(), "Classes should be final", new Object[]{name});
        }
    }

    private String getQualifiedClassName(DetailAST classast) {
        String name = classast.findFirstToken(58).getText();
        String outer = null;
        if (!this.classes.isEmpty()) {
            outer = this.classes.peek().getQualified();
        }
        return ProhibitNonFinalClassesCheck.getQualifiedClassName(this.pack, outer, name);
    }

    private static String getQualifiedClassName(String pack, String outer, String name) {
        String qualified = outer == null ? (pack.isEmpty() ? name : new UncheckedText((Text)new Joined(PACKAGE_SEPARATOR, new String[]{pack, name})).asString()) : new UncheckedText((Text)new Joined(PACKAGE_SEPARATOR, new String[]{outer, name})).asString();
        return qualified;
    }

    private static String getClassNameFromQualifiedName(String qualified) {
        return qualified.substring(qualified.lastIndexOf(PACKAGE_SEPARATOR) + 1);
    }

    private static final class ClassDesc {
        private final String qualified;
        private final boolean asfinal;
        private final boolean asabstract;

        ClassDesc(String qualified, boolean asfinal, boolean asabstract) {
            this.qualified = qualified;
            this.asfinal = asfinal;
            this.asabstract = asabstract;
        }

        private String getQualified() {
            return this.qualified;
        }

        private boolean isAsfinal() {
            return this.asfinal;
        }

        private boolean isDeclaredAsAbstract() {
            return this.asabstract;
        }
    }
}

