/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle.parameters;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Parameters {
    private final DetailAST node;
    private final int parent;
    private final int childs;

    public Parameters(DetailAST node, int parent, int childs) {
        this.node = node;
        this.parent = parent;
        this.childs = childs;
    }

    public final int count() {
        DetailAST params = this.node.findFirstToken(this.parent);
        int result = params == null ? 0 : params.getChildCount(this.childs);
        return result;
    }

    public final List<DetailAST> parameters() {
        List<DetailAST> result;
        int count = this.count();
        if (count == 0) {
            result = Collections.emptyList();
        } else {
            DetailAST params = this.node.findFirstToken(this.parent);
            result = new ArrayList<DetailAST>(count);
            for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != this.childs) continue;
                result.add(child);
            }
        }
        return result;
    }
}

