/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.findbugs;

import com.qulice.spi.Environment;
import com.qulice.spi.ValidationException;
import com.qulice.spi.Validator;
import com.ymock.util.Logger;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.PrintingBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.File;
import java.io.IOException;

public final class FindBugsValidator
implements Validator {
    public void validate(Environment env) throws ValidationException {
        if (!env.outdir().exists()) {
            Logger.info((Object)this, (String)"No classes at %s, no FindBugs validation", (Object[])new Object[]{env.outdir()});
            return;
        }
        FindBugs2 findbugs = new FindBugs2();
        findbugs.setProject(this.project(env));
        PrintingBugReporter reporter = new PrintingBugReporter();
        reporter.getProjectStats().getProfiler().start(findbugs.getClass());
        reporter.setPriorityThreshold(3);
        findbugs.setBugReporter((BugReporter)reporter);
        DetectorFactoryCollection.instance().ensureLoaded();
        findbugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        findbugs.setUserPreferences(UserPreferences.createDefaultUserPreferences());
        findbugs.setNoClassOk(true);
        findbugs.setScanNestedArchives(true);
        try {
            findbugs.execute();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        if (findbugs.getBugCount() > 0) {
            throw new ValidationException("%d FindBugs violations (see log above)", new Object[]{findbugs.getBugCount()});
        }
        Logger.info((Object)this, (String)"No FindBugs violations found", (Object[])new Object[0]);
    }

    private Project project(Environment env) {
        Project project = new Project();
        for (File jar : env.classpath()) {
            project.addFile(jar.getPath());
            Logger.debug((Object)this, (String)"#project(): added '%s'", (Object[])new Object[]{jar});
            if (jar.equals(env.outdir())) continue;
            project.addAuxClasspathEntry(jar.getPath());
        }
        project.addSourceDir(new File(env.basedir(), "src/main/java").getPath());
        return project;
    }
}

