/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.findbugs;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.PrintingBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public final class Wrap {
    private Wrap() {
    }

    public static void main(String ... args) {
        Wrap.run(args);
    }

    public static void run(String ... args) {
        Project project = Wrap.project(args[0], args[1], args[2].split(","));
        try {
            Plugin.loadCustomPlugin((File)new File(args[3]), (Project)project);
        }
        catch (PluginException ex) {
            throw new IllegalStateException(ex);
        }
        FindBugs2 findbugs = new FindBugs2();
        findbugs.setProject(project);
        final Collection ignored = Collections2.filter((Collection)Collections2.transform(Arrays.asList(BugType.values()), (Function)new Function<BugType, String>(){

            public String apply(BugType bug) {
                String name = bug == null ? "Missing" : bug.name();
                return name;
            }
        }), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)BugType.BED_BOGUS_EXCEPTION_DECLARATION.name())));
        PrintingBugReporter reporter = new PrintingBugReporter(){

            protected void doReportBug(BugInstance bug) {
                if (!ignored.contains(bug.getType())) {
                    super.doReportBug(bug);
                }
            }
        };
        reporter.getProjectStats().getProfiler().start(findbugs.getClass());
        reporter.setPriorityThreshold(3);
        findbugs.setBugReporter((BugReporter)reporter);
        findbugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        findbugs.setUserPreferences(UserPreferences.createDefaultUserPreferences());
        findbugs.setNoClassOk(true);
        findbugs.setScanNestedArchives(true);
        try {
            if (args.length > 4) {
                findbugs.addFilter(args[4], false);
            }
            findbugs.execute();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Project project(String basedir, String outdir, String ... paths) {
        Project project = new Project();
        for (String jar : paths) {
            if (jar.equals(outdir)) continue;
            project.addAuxClasspathEntry(jar);
        }
        project.addFile(outdir);
        project.addSourceDir(new File(basedir, "src/main/java").getPath());
        return project;
    }
}

