/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.findbugs;

import com.google.common.collect.Iterables;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseProcess;
import com.mebigfatguy.fbcontrib.FBContrib;
import com.qulice.findbugs.Wrap;
import com.qulice.spi.Environment;
import com.qulice.spi.ValidationException;
import com.qulice.spi.Validator;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.formatStringChecker.FormatterNumberFormatException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.annotation.meta.When;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.jaxen.JaxenException;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public final class FindBugsValidator
implements Validator {
    public void validate(Environment env) throws ValidationException {
        if (env.outdir().exists()) {
            if (!env.exclude("findbugs", "")) {
                this.check(this.findbugs(env));
            }
        } else {
            Logger.info((Object)this, (String)"No classes at %s, no FindBugs validation", (Object[])new Object[]{env.outdir()});
        }
    }

    public String name() {
        return "FindBugs";
    }

    private String findbugs(Environment env) {
        LinkedList<String> args = new LinkedList<String>();
        args.add("java");
        args.addAll(this.options());
        args.add(Wrap.class.getName());
        args.add(env.basedir().getPath());
        args.add(env.outdir().getPath());
        args.add(StringUtils.join((Iterable)env.classpath(), (String)",").replace("\\", "/"));
        Collection excludes = env.excludes("findbugs");
        args.add(this.jar(FBContrib.class).toString());
        if (excludes.iterator().hasNext()) {
            args.add(FindBugsValidator.excludes(env, excludes));
        }
        return new VerboseProcess(new ProcessBuilder(args), Level.INFO, Level.INFO).stdout();
    }

    private Collection<String> options() {
        LinkedList<String> opts = new LinkedList<String>();
        opts.add("-classpath");
        opts.add(StringUtils.join(Arrays.asList(this.jar(Wrap.class), this.jar(FindBugs2.class), this.jar(ClassFormatException.class), this.jar(DocumentException.class), this.jar(JaxenException.class), this.jar(ClassNode.class), this.jar(ClassVisitor.class), this.jar(When.class), this.jar(FormatterNumberFormatException.class), this.jar(StringEscapeUtils.class), this.jar(FBContrib.class), this.jar(Iterables.class)), (String)System.getProperty("path.separator")).replace("\\", "/"));
        return opts;
    }

    private static String excludes(Environment env, Iterable<String> excludes) {
        String path = StringUtils.join((Object[])new String[]{env.tempdir().getPath(), System.getProperty("path.separator"), "findbug_excludes_", String.valueOf(System.nanoTime()), ".xml"});
        try {
            FileUtils.writeStringToFile((File)new File(path), (String)FindBugsValidator.generateExcludes(excludes), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException exc) {
            throw new IllegalStateException("can't generate exclude rules for findbugs", exc);
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"XFB_XML_FACTORY_BYPASS"}, justification="No other way to create dom4j XMLWriter")
    private static String generateExcludes(Iterable<String> excludes) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("FindBugsFilter").addElement("Match").addElement("Or");
        for (String exclude : excludes) {
            if (exclude == null) continue;
            root.addElement("Class").addAttribute("name", exclude);
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            new XMLWriter((OutputStream)out).write(document);
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private File jar(Class<?> resource) {
        String name = resource.getName().replace(".", "/");
        URL res = this.getClass().getResource(String.format("/%s.class", name));
        if (res == null) {
            throw new IllegalStateException(String.format("can't find JAR for %s", name));
        }
        String path = res.getFile().replaceAll("\\!.*$", "");
        File file = "jar".equals(FilenameUtils.getExtension((String)path)) ? new File(URI.create(path).getPath()) : new File(path).getParentFile().getParentFile().getParentFile().getParentFile();
        Logger.debug((Object)this, (String)"#jar(%s): found at %s", (Object[])new Object[]{resource.getName(), file});
        return file;
    }

    private void check(String report) throws ValidationException {
        int total = 0;
        for (String line : report.split(System.getProperty("line.separator"))) {
            if (!line.matches("[a-zA-Z ]+: .*")) continue;
            Logger.warn((Object)this, (String)"FindBugs: %s", (Object[])new Object[]{line});
            ++total;
        }
        if (total > 0) {
            throw new ValidationException("%d FindBugs violations (see log above)", new Object[]{total});
        }
    }
}

