/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.findbugs;

import com.jcabi.log.Logger;
import com.jcabi.log.VerboseProcess;
import com.qulice.findbugs.Wrap;
import com.qulice.spi.Environment;
import com.qulice.spi.ValidationException;
import com.qulice.spi.Validator;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.formatStringChecker.FormatterNumberFormatException;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.meta.When;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.jaxen.JaxenException;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.tree.ClassNode;

public final class FindBugsValidator
implements Validator {
    public void validate(Environment env) throws ValidationException {
        if (env.outdir().exists()) {
            if (!env.exclude("findbugs", "")) {
                this.check(this.findbugs(env));
            }
        } else {
            Logger.info((Object)this, (String)"No classes at %s, no FindBugs validation", (Object[])new Object[]{env.outdir()});
        }
    }

    private String findbugs(Environment env) {
        LinkedList<String> args = new LinkedList<String>();
        args.add("java");
        args.addAll(this.options(env));
        args.add(Wrap.class.getName());
        args.add(env.basedir().getPath());
        args.add(env.outdir().getPath());
        args.add(StringUtils.join((Iterable)env.classpath(), (String)",").replace("\\", "/"));
        return new VerboseProcess(new ProcessBuilder(args)).stdoutQuietly();
    }

    private Collection<String> options(Environment env) {
        File jar = this.jar(Wrap.class);
        LinkedList<String> opts = new LinkedList<String>();
        opts.add("-classpath");
        opts.add(StringUtils.join((Iterable)CollectionUtils.union(Arrays.asList(jar, this.jar(FindBugs2.class), this.jar(ClassFormatException.class), this.jar(DocumentException.class), this.jar(JaxenException.class), this.jar(ClassNode.class), this.jar(ClassVisitor.class), this.jar(When.class), this.jar(EmptyVisitor.class), this.jar(FormatterNumberFormatException.class)), (Collection)env.classpath()), (String)System.getProperty("path.separator")).replace("\\", "/"));
        return opts;
    }

    private File jar(Class<?> resource) {
        String name = resource.getName().replace(".", "/");
        URL res = this.getClass().getResource(String.format("/%s.class", name));
        if (res == null) {
            throw new IllegalStateException(String.format("can't find JAR for %s", name));
        }
        String path = res.getFile().replaceAll("\\!.*$", "");
        File file = "jar".equals(FilenameUtils.getExtension((String)path)) ? new File(URI.create(path).getPath()) : new File(path).getParentFile().getParentFile().getParentFile().getParentFile();
        Logger.debug((Object)this, (String)"#jar(%s): found at %s", (Object[])new Object[]{resource.getName(), file});
        return file;
    }

    private void check(String report) throws ValidationException {
        int total = 0;
        for (String line : report.split(System.getProperty("line.separator"))) {
            if (!line.matches("[a-zA-Z ]+: .*")) continue;
            Logger.warn((Object)this, (String)"FindBugs: %s", (Object[])new Object[]{line});
            ++total;
        }
        if (total > 0) {
            throw new ValidationException("%d FindBugs violations (see log above)", new Object[]{total});
        }
    }
}

