/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.PrintingBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.File;
import java.io.IOException;

public final class Wrap {
    public static void main(String ... args) {
        new Wrap().run(args);
    }

    public void run(String ... args) {
        FindBugs2 findbugs = new FindBugs2();
        findbugs.setProject(this.project(args[0], args[1], args[2].split(",")));
        PrintingBugReporter reporter = new PrintingBugReporter();
        reporter.getProjectStats().getProfiler().start(findbugs.getClass());
        reporter.setPriorityThreshold(3);
        findbugs.setBugReporter((BugReporter)reporter);
        findbugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        findbugs.setUserPreferences(UserPreferences.createDefaultUserPreferences());
        findbugs.setNoClassOk(true);
        findbugs.setScanNestedArchives(true);
        try {
            findbugs.execute();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Project project(String basedir, String outdir, String[] paths) {
        Project project = new Project();
        for (String jar : paths) {
            if (jar.equals(outdir)) continue;
            project.addAuxClasspathEntry(jar);
        }
        project.addFile(outdir);
        project.addSourceDir(new File(basedir, "src/main/java").getPath());
        return project;
    }
}

