/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.maven;

import com.qulice.checkstyle.CheckstyleValidator;
import com.qulice.codenarc.CodeNarcValidator;
import com.qulice.findbugs.FindBugsValidator;
import com.qulice.maven.CoberturaValidator;
import com.qulice.maven.DependenciesValidator;
import com.qulice.maven.DuplicateFinderValidator;
import com.qulice.maven.EnforcerValidator;
import com.qulice.maven.JslintValidator;
import com.qulice.maven.MavenValidator;
import com.qulice.maven.PomXpathValidator;
import com.qulice.maven.SnapshotsValidator;
import com.qulice.maven.SvnPropertiesValidator;
import com.qulice.maven.ValidatorsProvider;
import com.qulice.pmd.PmdValidator;
import com.qulice.spi.Environment;
import com.qulice.spi.ResourceValidator;
import com.qulice.spi.Validator;
import com.qulice.xml.XmlValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

final class DefaultValidatorsProvider
implements ValidatorsProvider {
    private final Environment env;

    DefaultValidatorsProvider(Environment env) {
        this.env = env;
    }

    @Override
    public Set<MavenValidator> internal() {
        LinkedHashSet<MavenValidator> validators = new LinkedHashSet<MavenValidator>();
        validators.add(new PomXpathValidator());
        validators.add(new EnforcerValidator());
        validators.add(new DuplicateFinderValidator());
        validators.add(new SvnPropertiesValidator());
        validators.add(new CoberturaValidator());
        validators.add(new DependenciesValidator());
        validators.add(new JslintValidator());
        validators.add(new SnapshotsValidator());
        return validators;
    }

    @Override
    public Set<Validator> external() {
        LinkedHashSet<Validator> validators = new LinkedHashSet<Validator>();
        validators.add((Validator)new PmdValidator());
        validators.add((Validator)new FindBugsValidator());
        validators.add((Validator)new XmlValidator());
        validators.add((Validator)new CodeNarcValidator());
        return validators;
    }

    @Override
    public Collection<ResourceValidator> externalResource() {
        return Collections.singleton(new CheckstyleValidator(this.env));
    }
}

