/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.maven;

import com.jcabi.log.Logger;
import com.qulice.maven.MavenEnvironment;
import com.qulice.maven.MavenValidator;
import com.qulice.spi.ValidationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;

public final class SnapshotsValidator
implements MavenValidator {
    @Override
    public void validate(MavenEnvironment env) throws ValidationException {
        String version;
        if (!env.exclude("snapshots", "") && !SnapshotsValidator.isSnapshot(version = env.project().getVersion())) {
            this.check(env);
        }
    }

    private void check(MavenEnvironment env) throws ValidationException {
        int errors = 0;
        for (Extension ext : env.project().getBuildExtensions()) {
            if (!SnapshotsValidator.isSnapshot(ext.getVersion())) continue;
            Logger.warn((Object)this, (String)"%s build extension is SNAPSHOT", (Object[])new Object[]{ext});
            ++errors;
        }
        for (Plugin plugin : env.project().getBuildPlugins()) {
            if (!SnapshotsValidator.isSnapshot(plugin.getVersion())) continue;
            Logger.warn((Object)this, (String)"%s build plugin is SNAPSHOT", (Object[])new Object[]{plugin});
            ++errors;
        }
        for (Dependency dep : env.project().getDependencies()) {
            if (!SnapshotsValidator.isSnapshot(dep.getVersion())) continue;
            Logger.warn((Object)this, (String)"%s dependency is SNAPSHOT", (Object[])new Object[]{dep});
            ++errors;
        }
        if (errors > 0) {
            Logger.warn((Object)this, (String)"The version of the project is not SNAPSHOT; there shouldn't not be any SNAPSHOT dependencies (%d found)", (Object[])new Object[]{errors});
            throw new ValidationException("%d dependencies are in SNAPSHOT state", new Object[]{errors});
        }
    }

    private static boolean isSnapshot(String version) {
        return version.endsWith("-SNAPSHOT");
    }
}

