/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.maven;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.jcabi.log.Logger;
import com.qulice.maven.MavenEnvironment;
import com.qulice.maven.MojoExecutor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.context.Context;

public final class DefaultMavenEnvironment
implements MavenEnvironment {
    private MavenProject iproject;
    private Context icontext;
    private final Properties iproperties = new Properties();
    private MojoExecutor exectr;
    private final Collection<String> exc = new LinkedList<String>();
    private final Collection<String> asser = new LinkedList<String>();

    public String param(String name, String value) {
        String ret = this.iproperties.getProperty(name);
        if (ret == null) {
            ret = value;
        }
        return ret;
    }

    public File basedir() {
        return this.iproject.getBasedir();
    }

    public File tempdir() {
        return new File(this.iproject.getBuild().getOutputDirectory());
    }

    public File outdir() {
        return new File(this.iproject.getBuild().getOutputDirectory());
    }

    public Collection<String> classpath() {
        LinkedList<String> paths = new LinkedList<String>();
        String blank = "%20";
        String whitespace = " ";
        try {
            for (String name : this.iproject.getRuntimeClasspathElements()) {
                paths.add(name.replace(File.separatorChar, '/').replaceAll(" ", "%20"));
            }
            for (Artifact artifact : this.iproject.getDependencyArtifacts()) {
                if (artifact.getFile() == null) continue;
                paths.add(artifact.getFile().getAbsolutePath().replace(File.separatorChar, '/').replaceAll(" ", "%20"));
            }
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new IllegalStateException("Failed to read classpath", ex);
        }
        return paths;
    }

    public ClassLoader classloader() {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (String path : this.classpath()) {
            try {
                urls.add(URI.create(String.format("file:///%s", path)).toURL());
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Failed to build URL", ex);
            }
        }
        URLClassLoader loader = new PrivilegedClassLoader(urls).run();
        for (URL url : loader.getURLs()) {
            Logger.debug((Object)this, (String)"Classpath: %s", (Object[])new Object[]{url});
        }
        return loader;
    }

    @Override
    public MavenProject project() {
        return this.iproject;
    }

    @Override
    public Properties properties() {
        return this.iproperties;
    }

    @Override
    public Context context() {
        return this.icontext;
    }

    @Override
    public Properties config() {
        return this.iproperties;
    }

    @Override
    public MojoExecutor executor() {
        return this.exectr;
    }

    @Override
    public Collection<String> asserts() {
        return this.asser;
    }

    public Collection<File> files(String pattern) {
        String[] dirs;
        LinkedList<File> files = new LinkedList<File>();
        WildcardFileFilter filter = new WildcardFileFilter(pattern);
        for (String dir : dirs = new String[]{"src"}) {
            File sources = new File(this.basedir(), dir);
            if (!sources.exists()) continue;
            files.addAll(FileUtils.listFiles((File)sources, (IOFileFilter)filter, (IOFileFilter)DirectoryFileFilter.INSTANCE));
        }
        return files;
    }

    public boolean exclude(String check, String name) {
        return Iterables.any(this.excludes(check), (Predicate)new PathPredicate(name));
    }

    public Collection<String> excludes(String checker) {
        Collection excludes = Collections2.transform(this.exc, (Function)new CheckerExcludes(checker));
        return Collections2.filter((Collection)excludes, (Predicate)Predicates.notNull());
    }

    public void setProject(MavenProject proj) {
        this.iproject = proj;
    }

    public void setContext(Context ctx) {
        this.icontext = ctx;
    }

    public void setMojoExecutor(MojoExecutor exec) {
        this.exectr = exec;
    }

    public void setProperty(String name, String value) {
        this.iproperties.setProperty(name, value);
    }

    public void setExcludes(Collection<String> exprs) {
        this.exc.clear();
        this.exc.addAll(exprs);
    }

    public void setAsser(Collection<String> ass) {
        this.asser.clear();
        this.asser.addAll(ass);
    }

    private static class CheckerExcludes
    implements Function<String, String> {
        private final String checker;

        CheckerExcludes(String checker) {
            this.checker = checker;
        }

        @Nullable
        public String apply(@Nullable String input) {
            String[] exclude;
            String result = null;
            if (input != null && this.checker.equals((exclude = input.split(":", 2))[0]) && exclude.length > 1) {
                result = exclude[1];
            }
            return result;
        }
    }

    private static class PathPredicate
    implements Predicate<String> {
        private final String name;

        PathPredicate(String name) {
            this.name = name;
        }

        public boolean apply(@Nullable String input) {
            return input != null && FilenameUtils.normalize((String)this.name, (boolean)true).matches(input);
        }
    }

    private static final class PrivilegedClassLoader
    implements PrivilegedAction<URLClassLoader> {
        private final List<URL> urls;

        private PrivilegedClassLoader(List<URL> urls) {
            this.urls = urls;
        }

        @Override
        public URLClassLoader run() {
            return new URLClassLoader(this.urls.toArray(new URL[this.urls.size()]), Thread.currentThread().getContextClassLoader());
        }
    }
}

