/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.pmd;

import com.jcabi.log.Logger;
import com.qulice.pmd.PmdListener;
import com.qulice.spi.Environment;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ThreadSafeReportListener;
import net.sourceforge.pmd.util.ResourceLoader;
import net.sourceforge.pmd.util.datasource.DataSource;

final class SourceValidator {
    private final RuleContext context = new RuleContext();
    private final PmdListener listener;
    private final PMDConfiguration config;

    SourceValidator(Environment env) {
        this.listener = new PmdListener(env);
        this.config = new PMDConfiguration();
    }

    public Collection<RuleViolation> validate(Collection<DataSource> sources, String path) {
        this.config.setRuleSets("com/qulice/pmd/ruleset.xml");
        this.config.setThreads(0);
        this.config.setMinimumPriority(RulePriority.LOW);
        this.config.setIgnoreIncrementalAnalysis(true);
        this.config.setShowSuppressedViolations(true);
        Report report = new Report();
        report.addListener((ThreadSafeReportListener)this.listener);
        this.context.setReport(report);
        for (DataSource source : sources) {
            String name = source.getNiceFileName(false, path);
            Logger.debug((Object)this, (String)"Processing file: %s", (Object[])new Object[]{name});
            this.context.setSourceCodeFilename(name);
            this.context.setSourceCodeFile(new File(name));
            this.validateOne(source);
        }
        report.errors().forEachRemaining(error -> Logger.error((Object)this, (String)"Processing error in %s: (%s) %s, %s[exception]", (Object[])new Object[]{error.getFile(), error.getMsg(), error.getDetail(), error.getError()}));
        report.configErrors().forEachRemaining(error -> Logger.error((Object)this, (String)"Config error %s: %s", (Object[])new Object[]{error.rule().getName(), error.issue()}));
        return this.listener.getViolations();
    }

    private void validateOne(DataSource source) {
        RuleSetFactory factory = new RuleSetFactory(new ResourceLoader(), RulePriority.LOW, false, true);
        PMD.processFiles((PMDConfiguration)this.config, (RuleSetFactory)factory, new LinkedList<DataSource>(Collections.singleton(source)), (RuleContext)this.context, Collections.emptyList());
    }
}

