/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.pmd.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.rule.AbstractInefficientZeroCheck;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.util.StringUtil;

public final class UseStringIsEmptyRule
extends AbstractInefficientZeroCheck {
    public boolean appliesToClassName(String name) {
        return StringUtil.isSame((String)name, (String)"String", (boolean)true, (boolean)true, (boolean)true);
    }

    public Map<String, List<String>> getComparisonTargets() {
        HashMap<String, List<String>> rules = new HashMap<String, List<String>>();
        rules.put("<", Arrays.asList("1"));
        rules.put(">", Arrays.asList("0"));
        rules.put("==", Arrays.asList("0"));
        rules.put("!=", Arrays.asList("0"));
        rules.put(">=", Arrays.asList("0", "1"));
        rules.put("<=", Arrays.asList("0"));
        return rules;
    }

    public boolean isTargetMethod(JavaNameOccurrence occ) {
        NameOccurrence name = occ.getNameForWhichThisIsAQualifier();
        return name != null && "length".equals(name.getImage());
    }

    public Object visit(ASTVariableDeclaratorId variable, Object data) {
        Node node = variable.getTypeNameNode();
        if (node instanceof ASTReferenceType) {
            Class clazz = variable.getType();
            String type = variable.getNameDeclaration().getTypeImage();
            if (clazz != null && !clazz.isArray() && this.appliesToClassName(type)) {
                List declarations = variable.getUsages();
                this.checkDeclarations(declarations, data);
            }
        }
        variable.childrenAccept((JavaParserVisitor)this, data);
        return data;
    }

    public Object visit(ASTMethodDeclaration declaration, Object data) {
        ASTResultType result = declaration.getResultType();
        if (!result.isVoid()) {
            ASTType node = (ASTType)result.jjtGetChild(0);
            Class clazz = node.getType();
            String type = node.getTypeImage();
            if (clazz != null && !clazz.isArray() && this.appliesToClassName(type)) {
                Scope scope = declaration.getScope().getParent();
                MethodNameDeclaration method = new MethodNameDeclaration(declaration.getMethodDeclarator());
                List declarations = (List)scope.getDeclarations(MethodNameDeclaration.class).get(method);
                this.checkDeclarations(declarations, data);
            }
        }
        declaration.childrenAccept((JavaParserVisitor)this, data);
        return data;
    }

    private void checkDeclarations(Iterable<NameOccurrence> occurrences, Object data) {
        for (NameOccurrence occurrence : occurrences) {
            JavaNameOccurrence jocc = (JavaNameOccurrence)occurrence;
            if (!this.isTargetMethod(jocc)) continue;
            JavaNode location = jocc.getLocation();
            Node expr = (Node)location.getFirstParentOfType(ASTExpression.class);
            this.checkNodeAndReport(data, (Node)occurrence.getLocation(), expr.jjtGetChild(0));
        }
    }
}

