/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.xml;

import com.jcabi.log.Logger;
import com.jcabi.xml.StrictXML;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.qulice.spi.Environment;
import com.qulice.spi.ValidationException;
import com.qulice.spi.Validator;
import com.qulice.xml.Prettifier;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public final class XmlValidator
implements Validator {
    private static final String ESCAPED_EOL = "\\n";
    private static final Pattern ATTRS_PATTERN = Pattern.compile("^ *[^ <].*");
    private final transient boolean format;

    public XmlValidator() {
        this(true);
    }

    public XmlValidator(boolean formatting) {
        this.format = formatting;
    }

    public void validate(Environment env) throws ValidationException {
        try {
            for (File file : env.files("*.xml")) {
                String name = file.getAbsolutePath().substring(env.basedir().toString().length());
                if (env.exclude("xml", name)) {
                    Logger.info((Object)this, (String)"%s: skipped", (Object[])new Object[]{name});
                    continue;
                }
                Logger.info((Object)this, (String)"%s: to be validated", (Object[])new Object[]{name});
                XMLDocument document = new XMLDocument(file);
                try {
                    new StrictXML((XML)document);
                }
                catch (IllegalStateException ex) {
                    if (ex.getCause() != null && ex.getCause() instanceof SAXException) {
                        Logger.warn((Object)this, (String)"Failed to validate file %s against schema(s). Cause: %s", (Object[])new Object[]{name, ex.toString()});
                    }
                    throw new IllegalStateException(ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new ValidationException((Throwable)ex);
                }
                if (!this.format) continue;
                XmlValidator.formatting(file.toString(), FileUtils.readFileToString((File)file));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String name() {
        return "XML";
    }

    private static void formatting(String name, String before) throws ValidationException {
        String after = new Prettifier(before).prettify().replace("\r\n", "\n");
        String bnormalized = before.replace("\r\n", "\n");
        List<String> blines = Arrays.asList(bnormalized.split(ESCAPED_EOL, -1));
        Patch filter = XmlValidator.filter(DiffUtils.diff(blines, Arrays.asList(after.split(ESCAPED_EOL, -1))));
        if (!filter.getDeltas().isEmpty()) {
            int context = 5;
            throw new ValidationException("The provided XML %s is not well formatted, it should look like this:\n%s\npatch:\n%s", new Object[]{name, after, StringUtils.join((Iterable)DiffUtils.generateUnifiedDiff((String)"before", (String)"after", blines, (Patch)filter, (int)5), (String)"\n")});
        }
    }

    private static Patch filter(Patch diff) {
        Patch patch = new Patch();
        for (Delta delta : diff.getDeltas()) {
            List prev = delta.getOriginal().getLines();
            if (prev.size() == 1 && delta.getRevised().getLines().size() == 1 && ATTRS_PATTERN.matcher(prev.get(0).toString()).matches()) continue;
            patch.addDelta(delta);
        }
        return patch;
    }
}

