/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.link;

import com.qwazr.component.ComponentsManager;
import com.qwazr.library.freemarker.FreeMarkerTool;
import com.qwazr.link.servlets.EditorServlet;
import com.qwazr.link.servlets.IndexServlet;
import com.qwazr.link.servlets.JobsServlet;
import com.qwazr.link.servlets.LibraryServlet;
import com.qwazr.scripts.ScriptManager;
import com.qwazr.server.BaseServer;
import com.qwazr.server.GenericServer;
import com.qwazr.server.GenericServerBuilder;
import com.qwazr.server.ServletContextBuilder;
import com.qwazr.server.configuration.ServerConfiguration;
import com.qwazr.webapps.WebappManager;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LinkServer
implements BaseServer {
    private final GenericServer server;

    private LinkServer(ServerConfiguration configuration) throws IOException, ReflectiveOperationException {
        ExecutorService executorService = Executors.newCachedThreadPool();
        GenericServerBuilder builder = GenericServer.of((ServerConfiguration)configuration, (ExecutorService)executorService);
        ComponentsManager componentManager = new ComponentsManager().registerServices();
        FreeMarkerTool freemarkerResources = FreeMarkerTool.of().useClassloader(Boolean.valueOf(true)).build();
        freemarkerResources.load();
        ScriptManager scriptManager = new ScriptManager(executorService, null);
        WebappManager.Builder webappBuilder = WebappManager.of((GenericServerBuilder)builder, (ServletContextBuilder)builder.getWebAppContext());
        webappBuilder.registerJavaServlet(IndexServlet.class, () -> new IndexServlet(freemarkerResources, scriptManager));
        webappBuilder.registerJavaServlet(JobsServlet.class, () -> new JobsServlet(freemarkerResources));
        webappBuilder.registerJavaServlet(LibraryServlet.class, () -> new LibraryServlet(freemarkerResources, componentManager));
        webappBuilder.registerJavaServlet(EditorServlet.class, () -> new EditorServlet(freemarkerResources));
        webappBuilder.registerStaticServlet("/s/*", "com.qwazr.link.front.statics");
        webappBuilder.build();
        this.server = builder.build();
    }

    public GenericServer getServer() {
        return this.server;
    }

    public static void main(String ... args) throws Exception {
        new LinkServer(new ServerConfiguration(args)).start();
    }
}

