/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.link.servlets;

import com.qwazr.library.freemarker.FreeMarkerTool;
import com.qwazr.link.servlets.LinkException;
import com.qwazr.link.servlets.Transaction;
import com.qwazr.utils.LoggerUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringEscapeUtils;

abstract class AbstractServlet
extends HttpServlet {
    final FreeMarkerTool freeMarkerTool;
    private static final Logger LOGGER = LoggerUtils.getLogger(AbstractServlet.class);

    AbstractServlet(FreeMarkerTool freeMarkerTool) {
        this.freeMarkerTool = freeMarkerTool;
    }

    protected final void template(String templatePath, Transaction transaction) throws ServletException, IOException {
        try {
            this.freeMarkerTool.template(templatePath, transaction.dataModel, transaction.response);
        }
        catch (TemplateException e) {
            transaction.response.reset();
            transaction.response.setStatus(500);
            transaction.response.setContentType("text/html");
            try (PrintWriter pw = transaction.response.getWriter();){
                pw.println("<html><body><pre>");
                pw.println(StringEscapeUtils.escapeHtml4((String)e.getMessage()));
                pw.println("</pre></body></html>");
            }
            catch (IllegalStateException e2) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doGet(Transaction transaction) throws ServletException, IOException {
        super.doGet(transaction.request, transaction.response);
    }

    private void logger(Transaction transaction, DoMethod method) throws ServletException, IOException {
        try {
            method.doMethod(transaction);
        }
        catch (LinkException e) {
            LOGGER.log(Level.WARNING, e, e::getMessage);
            if (transaction.response.isCommitted()) {
                throw e;
            }
            e.sendError(transaction.response);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e, e::getMessage);
            throw e;
        }
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger(new Transaction(request, response), this::doGet);
    }

    protected void doPost(Transaction transaction) throws ServletException, IOException {
        super.doPost(transaction.request, transaction.response);
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger(new Transaction(request, response), this::doPost);
    }

    @FunctionalInterface
    public static interface DoMethod {
        public void doMethod(Transaction var1) throws ServletException, IOException;
    }
}

