/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.link.servlets;

import com.qwazr.library.freemarker.FreeMarkerTool;
import com.qwazr.link.servlets.AbstractServlet;
import com.qwazr.link.servlets.SessionWrapper;
import com.qwazr.link.servlets.Transaction;
import com.qwazr.scripts.RunThreadAbstract;
import com.qwazr.scripts.ScriptManager;
import com.qwazr.utils.IOUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;

@WebServlet(name="index", urlPatterns={""})
public class IndexServlet
extends AbstractServlet {
    final ScriptManager scriptManager;

    public IndexServlet(FreeMarkerTool freemarker, ScriptManager scriptManager) {
        super(freemarker);
        this.scriptManager = scriptManager;
    }

    @Override
    protected void doGet(Transaction transaction) throws ServletException, IOException {
        transaction.dataModel.put("linkscript", transaction.session.getAttribute(SessionWrapper.Attributes.LINKSCRIPT, String.class));
        this.template("/com/qwazr/link/front/templates/index.ftl", transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(Transaction transaction) throws ServletException, IOException {
        String linkScript = transaction.getRequestParameter("linkscript");
        transaction.session.setAttribute(SessionWrapper.Attributes.LINKSCRIPT, linkScript);
        Path scriptPath = Files.createTempFile("qwazr-link", ".js", new FileAttribute[0]);
        try {
            IOUtils.writeStringToPath((String)linkScript, (Charset)StandardCharsets.UTF_8, (Path)scriptPath);
            RunThreadAbstract run = this.scriptManager.getService().runSync(scriptPath.toString(), null);
            Exception e = run.getException();
            if (e != null) {
                transaction.addMessage(e);
            }
            transaction.dataModel.put("scriptout", run.getOut());
        }
        catch (ClassNotFoundException e) {
            transaction.addMessage(e);
        }
        finally {
            Files.deleteIfExists(scriptPath);
        }
        this.doGet(transaction);
    }
}

