/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.link.servlets;

import com.qwazr.link.servlets.Messages;
import com.qwazr.link.servlets.Transaction;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringEscapeUtils;

public class LinkException
extends RuntimeException {
    private final String title;

    public LinkException(String title, String message, Throwable cause) {
        super(message, cause);
        this.title = title;
    }

    String getTitle() {
        return this.title;
    }

    void addMessage(Transaction transaction) {
        transaction.addMessage(Messages.Type.danger, this.title, this.getMessage(), true);
    }

    void sendError(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(500);
        try (PrintWriter writer = response.getWriter();){
            writer.println("<h3>" + StringEscapeUtils.escapeHtml4((String)this.title) + "</h3>");
            writer.println("<p>" + StringEscapeUtils.escapeHtml4((String)this.getMessage()) + "</p>");
        }
    }
}

