/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.link.servlets;

import com.qwazr.link.servlets.LinkException;
import com.qwazr.link.servlets.Messages;
import com.qwazr.link.servlets.SessionWrapper;
import com.qwazr.utils.LoggerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class Transaction {
    private static final Logger LOGGER = LoggerUtils.getLogger(Transaction.class);
    final HttpServletRequest request;
    final HttpServletResponse response;
    final Map<String, Object> dataModel;
    final SessionWrapper session;

    Transaction(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.session = new SessionWrapper(request);
        this.dataModel = new HashMap<String, Object>();
        this.dataModel.put("request", request);
        this.dataModel.put("session", this.session);
    }

    String getRequestParameter(String name) {
        return this.request.getParameter(name);
    }

    Integer getRequestParameter(String name, Integer defaultValue) {
        String value = this.getRequestParameter(name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    void addMessage(Messages.Type type, String title, String message, boolean close) {
        this.session.getMessages().add(type, title, message, close);
    }

    void addMessage(Throwable throwable) {
        LOGGER.log(Level.SEVERE, throwable, throwable::getMessage);
        String title = throwable instanceof LinkException ? ((LinkException)throwable).getTitle() : throwable.getClass().getName();
        this.session.getMessages().add(Messages.Type.danger, title, throwable.getMessage(), true);
    }
}

