/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr;

import android.animation.ArgbEvaluator;
import android.app.Activity;
import android.os.Build;
import androidx.annotation.ColorInt;
import com.r0adkll.slidr.widget.SliderPanel;

class ColorPanelSlideListener
implements SliderPanel.OnPanelSlideListener {
    private final Activity activity;
    private final int primaryColor;
    private final int secondaryColor;
    private final ArgbEvaluator evaluator = new ArgbEvaluator();

    ColorPanelSlideListener(Activity activity, @ColorInt int primaryColor, @ColorInt int secondaryColor) {
        this.activity = activity;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    @Override
    public void onStateChanged(int state) {
    }

    @Override
    public void onClosed() {
        this.activity.finish();
        this.activity.overridePendingTransition(0, 0);
    }

    @Override
    public void onOpened() {
    }

    @Override
    public void onSlideChange(float percent) {
        if (Build.VERSION.SDK_INT >= 21 && this.areColorsValid()) {
            int newColor = (Integer)this.evaluator.evaluate(percent, (Object)this.getPrimaryColor(), (Object)this.getSecondaryColor());
            this.activity.getWindow().setStatusBarColor(newColor);
        }
    }

    protected int getPrimaryColor() {
        return this.primaryColor;
    }

    protected int getSecondaryColor() {
        return this.secondaryColor;
    }

    protected boolean areColorsValid() {
        return this.getPrimaryColor() != -1 && this.getSecondaryColor() != -1;
    }
}

