/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ChannelManager {
    private final Map<Integer, ChannelN> _channelMap = Collections.synchronizedMap(new HashMap());
    public int _channelMax = 0;

    public synchronized int getChannelMax() {
        return this._channelMax;
    }

    public synchronized void setChannelMax(int value) {
        this._channelMax = value;
    }

    public ChannelN getChannel(int channelNumber) {
        return this._channelMap.get(channelNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSignal(ShutdownSignalException signal) {
        HashSet<ChannelN> channels;
        Map<Integer, ChannelN> map = this._channelMap;
        synchronized (map) {
            channels = new HashSet<ChannelN>(this._channelMap.values());
        }
        for (ChannelN channel : channels) {
            this.disconnectChannel(channel.getChannelNumber());
            ((AMQChannel)channel).processShutdownSignal(signal);
        }
    }

    public synchronized ChannelN createChannel(AMQConnection connection) throws IOException {
        int channelNumber = this.allocateChannelNumber(this.getChannelMax());
        if (channelNumber == -1) {
            return null;
        }
        return this.createChannel(connection, channelNumber);
    }

    public synchronized ChannelN createChannel(AMQConnection connection, int channelNumber) throws IOException {
        ChannelN ch = new ChannelN(connection, channelNumber);
        if (this._channelMap.containsKey(channelNumber)) {
            return null;
        }
        this.addChannel(ch);
        ch.open();
        return ch;
    }

    public synchronized int allocateChannelNumber(int maxChannels) {
        if (maxChannels == 0) {
            maxChannels = Integer.MAX_VALUE;
        }
        int channelNumber = -1;
        for (int candidate = 1; candidate < maxChannels; ++candidate) {
            if (this._channelMap.containsKey(candidate)) continue;
            channelNumber = candidate;
            break;
        }
        return channelNumber;
    }

    private void addChannel(ChannelN chan) {
        this._channelMap.put(chan.getChannelNumber(), chan);
    }

    public void disconnectChannel(int channelNumber) {
        this._channelMap.remove(channelNumber);
    }
}

