/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools;

import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.utility.BlockingCell;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Tracer
implements Runnable {
    public static final boolean WITHHOLD_INBOUND_HEARTBEATS = new Boolean(System.getProperty("com.rabbitmq.tools.Tracer.WITHHOLD_INBOUND_HEARTBEATS"));
    public static final boolean WITHHOLD_OUTBOUND_HEARTBEATS = new Boolean(System.getProperty("com.rabbitmq.tools.Tracer.WITHHOLD_OUTBOUND_HEARTBEATS"));
    public static final boolean NO_ASSEMBLE_FRAMES = new Boolean(System.getProperty("com.rabbitmq.tools.Tracer.NO_ASSEMBLE_FRAMES"));
    public static final boolean NO_DECODE_FRAMES = new Boolean(System.getProperty("com.rabbitmq.tools.Tracer.NO_DECODE_FRAMES"));
    public Socket inSock;
    public Socket outSock;
    public int id;
    public DataInputStream iis;
    public DataOutputStream ios;
    public DataInputStream ois;
    public DataOutputStream oos;

    public static void main(String[] args) {
        int listenPort = args.length > 0 ? Integer.parseInt(args[0]) : 5673;
        String connectHost = args.length > 1 ? args[1] : "localhost";
        int connectPort = args.length > 2 ? Integer.parseInt(args[2]) : 5672;
        System.out.println("Usage: Tracer [<listenport> [<connecthost> [<connectport>]]]");
        System.out.println("Invoked as: Tracer " + listenPort + " " + connectHost + " " + connectPort);
        System.out.println("com.rabbitmq.tools.Tracer.WITHHOLD_INBOUND_HEARTBEATS = " + WITHHOLD_INBOUND_HEARTBEATS);
        System.out.println("com.rabbitmq.tools.Tracer.WITHHOLD_OUTBOUND_HEARTBEATS = " + WITHHOLD_OUTBOUND_HEARTBEATS);
        System.out.println("com.rabbitmq.tools.Tracer.NO_ASSEMBLE_FRAMES = " + NO_ASSEMBLE_FRAMES);
        System.out.println("com.rabbitmq.tools.Tracer.NO_DECODE_FRAMES = " + NO_DECODE_FRAMES);
        try {
            ServerSocket server = new ServerSocket(listenPort);
            int counter = 0;
            while (true) {
                Socket conn = server.accept();
                ++counter;
                new Tracer(conn, counter, connectHost, connectPort);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public Tracer(Socket sock, int id, String host, int port) throws IOException {
        this.inSock = sock;
        this.outSock = new Socket(host, port);
        this.id = id;
        this.iis = new DataInputStream(this.inSock.getInputStream());
        this.ios = new DataOutputStream(this.inSock.getOutputStream());
        this.ois = new DataInputStream(this.outSock.getInputStream());
        this.oos = new DataOutputStream(this.outSock.getOutputStream());
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] handshake = new byte[8];
            this.iis.readFully(handshake);
            this.oos.write(handshake);
            BlockingCell<Object> w = new BlockingCell<Object>();
            DirectionHandler inHandler = new DirectionHandler(w, true, this.iis, this.oos);
            DirectionHandler outHandler = new DirectionHandler(w, false, this.ois, this.ios);
            new Thread(inHandler).start();
            new Thread(outHandler).start();
            Object result = w.uninterruptibleGet();
            if (result instanceof Exception) {
                ((Exception)result).printStackTrace();
            }
        }
        catch (EOFException eofe) {
            eofe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                this.inSock.close();
                this.outSock.close();
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DirectionHandler
    implements Runnable {
        public BlockingCell<Object> waitCell;
        public boolean inBound;
        public DataInputStream i;
        public DataOutputStream o;
        public AMQCommand.Assembler c;

        public DirectionHandler(BlockingCell<Object> waitCell, boolean inBound, DataInputStream i, DataOutputStream o) {
            this.waitCell = waitCell;
            this.inBound = inBound;
            this.i = i;
            this.o = o;
            this.c = AMQCommand.newAssembler();
        }

        public Frame readFrame() throws IOException {
            return Frame.readFrom(this.i);
        }

        public void report(int channel, Object object) {
            System.out.println("" + System.currentTimeMillis() + ": conn#" + Tracer.this.id + " ch#" + channel + (this.inBound ? " -> " : " <- ") + object);
        }

        public void reportFrame(Frame f) throws IOException {
            switch (f.type) {
                case 1: {
                    this.report(f.channel, AMQImpl.readMethodFrom(f.getInputStream()));
                    break;
                }
                case 2: {
                    DataInputStream in = f.getInputStream();
                    AMQContentHeader contentHeader = AMQImpl.readContentHeaderFrom(in);
                    long remainingBodyBytes = contentHeader.readFrom(in);
                    this.report(f.channel, "Expected body size: " + remainingBodyBytes + "; " + contentHeader.toString());
                    break;
                }
                default: {
                    this.report(f.channel, f);
                }
            }
        }

        public void doFrame() throws IOException {
            Frame f = this.readFrame();
            if (f != null) {
                if (f.type == 8) {
                    if (this.inBound && !WITHHOLD_INBOUND_HEARTBEATS || !this.inBound && !WITHHOLD_OUTBOUND_HEARTBEATS) {
                        f.writeTo(this.o);
                        this.report(f.channel, f);
                    } else {
                        this.report(f.channel, "(withheld) " + f.toString());
                    }
                } else {
                    f.writeTo(this.o);
                    if (NO_ASSEMBLE_FRAMES || NO_DECODE_FRAMES) {
                        if (NO_DECODE_FRAMES) {
                            this.report(f.channel, f);
                        } else {
                            this.reportFrame(f);
                        }
                    } else {
                        AMQCommand cmd = this.c.handleFrame(f);
                        if (cmd != null) {
                            this.report(f.channel, cmd);
                            this.c = AMQCommand.newAssembler();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        this.doFrame();
                    }
                }
                catch (Exception e) {
                    this.waitCell.setIfUnset(e);
                    this.waitCell.setIfUnset(new Object());
                }
            }
            catch (Throwable throwable) {
                this.waitCell.setIfUnset(new Object());
                throw throwable;
            }
        }
    }
}

