//   NOTE: This -*- java -*- source code is autogenerated from the AMQP
//         specification!
//
//  The contents of this file are subject to the Mozilla Public License
//  Version 1.1 (the "License"); you may not use this file except in
//  compliance with the License. You may obtain a copy of the License
//  at http://www.mozilla.org/MPL/
//
//  Software distributed under the License is distributed on an "AS IS"
//  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
//  the License for the specific language governing rights and
//  limitations under the License.
//
//  The Original Code is RabbitMQ.
//
//  The Initial Developer of the Original Code is GoPivotal, Inc.
//  Copyright (c) 2007-2014 GoPivotal, Inc.  All rights reserved.
//

package com.rabbitmq.client;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Date;

import com.rabbitmq.client.impl.ContentHeaderPropertyWriter;
import com.rabbitmq.client.impl.ContentHeaderPropertyReader;
import com.rabbitmq.client.impl.LongStringHelper;

public interface AMQP {

    public static class PROTOCOL {
        public static final int MAJOR = 0;
        public static final int MINOR = 9;
        public static final int REVISION = 1;
        public static final int PORT = 5672;
    }

    public static final int FRAME_METHOD = 1;
    public static final int FRAME_HEADER = 2;
    public static final int FRAME_BODY = 3;
    public static final int FRAME_HEARTBEAT = 8;
    public static final int FRAME_MIN_SIZE = 4096;
    public static final int FRAME_END = 206;
    public static final int REPLY_SUCCESS = 200;
    public static final int CONTENT_TOO_LARGE = 311;
    public static final int NO_ROUTE = 312;
    public static final int NO_CONSUMERS = 313;
    public static final int ACCESS_REFUSED = 403;
    public static final int NOT_FOUND = 404;
    public static final int RESOURCE_LOCKED = 405;
    public static final int PRECONDITION_FAILED = 406;
    public static final int CONNECTION_FORCED = 320;
    public static final int INVALID_PATH = 402;
    public static final int FRAME_ERROR = 501;
    public static final int SYNTAX_ERROR = 502;
    public static final int COMMAND_INVALID = 503;
    public static final int CHANNEL_ERROR = 504;
    public static final int UNEXPECTED_FRAME = 505;
    public static final int RESOURCE_ERROR = 506;
    public static final int NOT_ALLOWED = 530;
    public static final int NOT_IMPLEMENTED = 540;
    public static final int INTERNAL_ERROR = 541;

    public static class Connection {
        public interface Start extends Method {
            int getVersionMajor();
            int getVersionMinor();
            Map<String,Object> getServerProperties();
            LongString getMechanisms();
            LongString getLocales();

            // Builder for instances of Connection.Start
            public static final class Builder
            {
                private int versionMajor = 0;
                private int versionMinor = 9;
                private Map<String,Object> serverProperties;
                private LongString mechanisms = LongStringHelper.asLongString("PLAIN");
                private LongString locales = LongStringHelper.asLongString("en_US");

                public Builder() { }

                public Builder versionMajor(int versionMajor)
                {   this.versionMajor = versionMajor; return this; }
                public Builder versionMinor(int versionMinor)
                {   this.versionMinor = versionMinor; return this; }
                public Builder serverProperties(Map<String,Object> serverProperties)
                {   this.serverProperties = serverProperties; return this; }
                public Builder mechanisms(LongString mechanisms)
                {   this.mechanisms = mechanisms; return this; }
                public Builder mechanisms(String mechanisms)
                {   return this.mechanisms(LongStringHelper.asLongString(mechanisms)); }
                public Builder locales(LongString locales)
                {   this.locales = locales; return this; }
                public Builder locales(String locales)
                {   return this.locales(LongStringHelper.asLongString(locales)); }
                public Start build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.Start(versionMajor, versionMinor, serverProperties, mechanisms, locales);
                }
            }
        }
        public interface StartOk extends Method {
            Map<String,Object> getClientProperties();
            String getMechanism();
            LongString getResponse();
            String getLocale();

            // Builder for instances of Connection.StartOk
            public static final class Builder
            {
                private Map<String,Object> clientProperties;
                private String mechanism = "PLAIN";
                private LongString response;
                private String locale = "en_US";

                public Builder() { }

                public Builder clientProperties(Map<String,Object> clientProperties)
                {   this.clientProperties = clientProperties; return this; }
                public Builder mechanism(String mechanism)
                {   this.mechanism = mechanism; return this; }
                public Builder response(LongString response)
                {   this.response = response; return this; }
                public Builder response(String response)
                {   return this.response(LongStringHelper.asLongString(response)); }
                public Builder locale(String locale)
                {   this.locale = locale; return this; }
                public StartOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.StartOk(clientProperties, mechanism, response, locale);
                }
            }
        }
        public interface Secure extends Method {
            LongString getChallenge();

            // Builder for instances of Connection.Secure
            public static final class Builder
            {
                private LongString challenge;

                public Builder() { }

                public Builder challenge(LongString challenge)
                {   this.challenge = challenge; return this; }
                public Builder challenge(String challenge)
                {   return this.challenge(LongStringHelper.asLongString(challenge)); }
                public Secure build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.Secure(challenge);
                }
            }
        }
        public interface SecureOk extends Method {
            LongString getResponse();

            // Builder for instances of Connection.SecureOk
            public static final class Builder
            {
                private LongString response;

                public Builder() { }

                public Builder response(LongString response)
                {   this.response = response; return this; }
                public Builder response(String response)
                {   return this.response(LongStringHelper.asLongString(response)); }
                public SecureOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.SecureOk(response);
                }
            }
        }
        public interface Tune extends Method {
            int getChannelMax();
            int getFrameMax();
            int getHeartbeat();

            // Builder for instances of Connection.Tune
            public static final class Builder
            {
                private int channelMax = 0;
                private int frameMax = 0;
                private int heartbeat = 0;

                public Builder() { }

                public Builder channelMax(int channelMax)
                {   this.channelMax = channelMax; return this; }
                public Builder frameMax(int frameMax)
                {   this.frameMax = frameMax; return this; }
                public Builder heartbeat(int heartbeat)
                {   this.heartbeat = heartbeat; return this; }
                public Tune build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.Tune(channelMax, frameMax, heartbeat);
                }
            }
        }
        public interface TuneOk extends Method {
            int getChannelMax();
            int getFrameMax();
            int getHeartbeat();

            // Builder for instances of Connection.TuneOk
            public static final class Builder
            {
                private int channelMax = 0;
                private int frameMax = 0;
                private int heartbeat = 0;

                public Builder() { }

                public Builder channelMax(int channelMax)
                {   this.channelMax = channelMax; return this; }
                public Builder frameMax(int frameMax)
                {   this.frameMax = frameMax; return this; }
                public Builder heartbeat(int heartbeat)
                {   this.heartbeat = heartbeat; return this; }
                public TuneOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.TuneOk(channelMax, frameMax, heartbeat);
                }
            }
        }
        public interface Open extends Method {
            String getVirtualHost();
            String getCapabilities();
            boolean getInsist();

            // Builder for instances of Connection.Open
            public static final class Builder
            {
                private String virtualHost = "/";
                private String capabilities = "";
                private boolean insist = false;

                public Builder() { }

                public Builder virtualHost(String virtualHost)
                {   this.virtualHost = virtualHost; return this; }
                public Builder capabilities(String capabilities)
                {   this.capabilities = capabilities; return this; }
                public Builder insist(boolean insist)
                {   this.insist = insist; return this; }
                public Builder insist()
                {   return this.insist(true); }
                public Open build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.Open(virtualHost, capabilities, insist);
                }
            }
        }
        public interface OpenOk extends Method {
            String getKnownHosts();

            // Builder for instances of Connection.OpenOk
            public static final class Builder
            {
                private String knownHosts = "";

                public Builder() { }

                public Builder knownHosts(String knownHosts)
                {   this.knownHosts = knownHosts; return this; }
                public OpenOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.OpenOk(knownHosts);
                }
            }
        }
        public interface Close extends Method {
            int getReplyCode();
            String getReplyText();
            int getClassId();
            int getMethodId();

            // Builder for instances of Connection.Close
            public static final class Builder
            {
                private int replyCode;
                private String replyText = "";
                private int classId;
                private int methodId;

                public Builder() { }

                public Builder replyCode(int replyCode)
                {   this.replyCode = replyCode; return this; }
                public Builder replyText(String replyText)
                {   this.replyText = replyText; return this; }
                public Builder classId(int classId)
                {   this.classId = classId; return this; }
                public Builder methodId(int methodId)
                {   this.methodId = methodId; return this; }
                public Close build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.Close(replyCode, replyText, classId, methodId);
                }
            }
        }
        public interface CloseOk extends Method {

            // Builder for instances of Connection.CloseOk
            public static final class Builder
            {

                public Builder() { }

                public CloseOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.CloseOk();
                }
            }
        }
        public interface Blocked extends Method {
            String getReason();

            // Builder for instances of Connection.Blocked
            public static final class Builder
            {
                private String reason = "";

                public Builder() { }

                public Builder reason(String reason)
                {   this.reason = reason; return this; }
                public Blocked build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.Blocked(reason);
                }
            }
        }
        public interface Unblocked extends Method {

            // Builder for instances of Connection.Unblocked
            public static final class Builder
            {

                public Builder() { }

                public Unblocked build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Connection.Unblocked();
                }
            }
        }
    }

    public static class Channel {
        public interface Open extends Method {
            String getOutOfBand();

            // Builder for instances of Channel.Open
            public static final class Builder
            {
                private String outOfBand = "";

                public Builder() { }

                public Builder outOfBand(String outOfBand)
                {   this.outOfBand = outOfBand; return this; }
                public Open build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Channel.Open(outOfBand);
                }
            }
        }
        public interface OpenOk extends Method {
            LongString getChannelId();

            // Builder for instances of Channel.OpenOk
            public static final class Builder
            {
                private LongString channelId = LongStringHelper.asLongString("");

                public Builder() { }

                public Builder channelId(LongString channelId)
                {   this.channelId = channelId; return this; }
                public Builder channelId(String channelId)
                {   return this.channelId(LongStringHelper.asLongString(channelId)); }
                public OpenOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Channel.OpenOk(channelId);
                }
            }
        }
        public interface Flow extends Method {
            boolean getActive();

            // Builder for instances of Channel.Flow
            public static final class Builder
            {
                private boolean active;

                public Builder() { }

                public Builder active(boolean active)
                {   this.active = active; return this; }
                public Builder active()
                {   return this.active(true); }
                public Flow build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Channel.Flow(active);
                }
            }
        }
        public interface FlowOk extends Method {
            boolean getActive();

            // Builder for instances of Channel.FlowOk
            public static final class Builder
            {
                private boolean active;

                public Builder() { }

                public Builder active(boolean active)
                {   this.active = active; return this; }
                public Builder active()
                {   return this.active(true); }
                public FlowOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Channel.FlowOk(active);
                }
            }
        }
        public interface Close extends Method {
            int getReplyCode();
            String getReplyText();
            int getClassId();
            int getMethodId();

            // Builder for instances of Channel.Close
            public static final class Builder
            {
                private int replyCode;
                private String replyText = "";
                private int classId;
                private int methodId;

                public Builder() { }

                public Builder replyCode(int replyCode)
                {   this.replyCode = replyCode; return this; }
                public Builder replyText(String replyText)
                {   this.replyText = replyText; return this; }
                public Builder classId(int classId)
                {   this.classId = classId; return this; }
                public Builder methodId(int methodId)
                {   this.methodId = methodId; return this; }
                public Close build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Channel.Close(replyCode, replyText, classId, methodId);
                }
            }
        }
        public interface CloseOk extends Method {

            // Builder for instances of Channel.CloseOk
            public static final class Builder
            {

                public Builder() { }

                public CloseOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Channel.CloseOk();
                }
            }
        }
    }

    public static class Access {
        public interface Request extends Method {
            String getRealm();
            boolean getExclusive();
            boolean getPassive();
            boolean getActive();
            boolean getWrite();
            boolean getRead();

            // Builder for instances of Access.Request
            public static final class Builder
            {
                private String realm = "/data";
                private boolean exclusive = false;
                private boolean passive = true;
                private boolean active = true;
                private boolean write = true;
                private boolean read = true;

                public Builder() { }

                public Builder realm(String realm)
                {   this.realm = realm; return this; }
                public Builder exclusive(boolean exclusive)
                {   this.exclusive = exclusive; return this; }
                public Builder exclusive()
                {   return this.exclusive(true); }
                public Builder passive(boolean passive)
                {   this.passive = passive; return this; }
                public Builder passive()
                {   return this.passive(true); }
                public Builder active(boolean active)
                {   this.active = active; return this; }
                public Builder active()
                {   return this.active(true); }
                public Builder write(boolean write)
                {   this.write = write; return this; }
                public Builder write()
                {   return this.write(true); }
                public Builder read(boolean read)
                {   this.read = read; return this; }
                public Builder read()
                {   return this.read(true); }
                public Request build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Access.Request(realm, exclusive, passive, active, write, read);
                }
            }
        }
        public interface RequestOk extends Method {
            int getTicket();

            // Builder for instances of Access.RequestOk
            public static final class Builder
            {
                private int ticket = 1;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public RequestOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Access.RequestOk(ticket);
                }
            }
        }
    }

    public static class Exchange {
        public interface Declare extends Method {
            int getTicket();
            String getExchange();
            String getType();
            boolean getPassive();
            boolean getDurable();
            boolean getAutoDelete();
            boolean getInternal();
            boolean getNowait();
            Map<String,Object> getArguments();

            // Builder for instances of Exchange.Declare
            public static final class Builder
            {
                private int ticket = 0;
                private String exchange;
                private String type = "direct";
                private boolean passive = false;
                private boolean durable = false;
                private boolean autoDelete = false;
                private boolean internal = false;
                private boolean nowait = false;
                private Map<String,Object> arguments = null;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder exchange(String exchange)
                {   this.exchange = exchange; return this; }
                public Builder type(String type)
                {   this.type = type; return this; }
                public Builder passive(boolean passive)
                {   this.passive = passive; return this; }
                public Builder passive()
                {   return this.passive(true); }
                public Builder durable(boolean durable)
                {   this.durable = durable; return this; }
                public Builder durable()
                {   return this.durable(true); }
                public Builder autoDelete(boolean autoDelete)
                {   this.autoDelete = autoDelete; return this; }
                public Builder autoDelete()
                {   return this.autoDelete(true); }
                public Builder internal(boolean internal)
                {   this.internal = internal; return this; }
                public Builder internal()
                {   return this.internal(true); }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Builder arguments(Map<String,Object> arguments)
                {   this.arguments = arguments; return this; }
                public Declare build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Exchange.Declare(ticket, exchange, type, passive, durable, autoDelete, internal, nowait, arguments);
                }
            }
        }
        public interface DeclareOk extends Method {

            // Builder for instances of Exchange.DeclareOk
            public static final class Builder
            {

                public Builder() { }

                public DeclareOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Exchange.DeclareOk();
                }
            }
        }
        public interface Delete extends Method {
            int getTicket();
            String getExchange();
            boolean getIfUnused();
            boolean getNowait();

            // Builder for instances of Exchange.Delete
            public static final class Builder
            {
                private int ticket = 0;
                private String exchange;
                private boolean ifUnused = false;
                private boolean nowait = false;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder exchange(String exchange)
                {   this.exchange = exchange; return this; }
                public Builder ifUnused(boolean ifUnused)
                {   this.ifUnused = ifUnused; return this; }
                public Builder ifUnused()
                {   return this.ifUnused(true); }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Delete build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Exchange.Delete(ticket, exchange, ifUnused, nowait);
                }
            }
        }
        public interface DeleteOk extends Method {

            // Builder for instances of Exchange.DeleteOk
            public static final class Builder
            {

                public Builder() { }

                public DeleteOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Exchange.DeleteOk();
                }
            }
        }
        public interface Bind extends Method {
            int getTicket();
            String getDestination();
            String getSource();
            String getRoutingKey();
            boolean getNowait();
            Map<String,Object> getArguments();

            // Builder for instances of Exchange.Bind
            public static final class Builder
            {
                private int ticket = 0;
                private String destination;
                private String source;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String,Object> arguments = null;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder destination(String destination)
                {   this.destination = destination; return this; }
                public Builder source(String source)
                {   this.source = source; return this; }
                public Builder routingKey(String routingKey)
                {   this.routingKey = routingKey; return this; }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Builder arguments(Map<String,Object> arguments)
                {   this.arguments = arguments; return this; }
                public Bind build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Exchange.Bind(ticket, destination, source, routingKey, nowait, arguments);
                }
            }
        }
        public interface BindOk extends Method {

            // Builder for instances of Exchange.BindOk
            public static final class Builder
            {

                public Builder() { }

                public BindOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Exchange.BindOk();
                }
            }
        }
        public interface Unbind extends Method {
            int getTicket();
            String getDestination();
            String getSource();
            String getRoutingKey();
            boolean getNowait();
            Map<String,Object> getArguments();

            // Builder for instances of Exchange.Unbind
            public static final class Builder
            {
                private int ticket = 0;
                private String destination;
                private String source;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String,Object> arguments = null;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder destination(String destination)
                {   this.destination = destination; return this; }
                public Builder source(String source)
                {   this.source = source; return this; }
                public Builder routingKey(String routingKey)
                {   this.routingKey = routingKey; return this; }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Builder arguments(Map<String,Object> arguments)
                {   this.arguments = arguments; return this; }
                public Unbind build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Exchange.Unbind(ticket, destination, source, routingKey, nowait, arguments);
                }
            }
        }
        public interface UnbindOk extends Method {

            // Builder for instances of Exchange.UnbindOk
            public static final class Builder
            {

                public Builder() { }

                public UnbindOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Exchange.UnbindOk();
                }
            }
        }
    }

    public static class Queue {
        public interface Declare extends Method {
            int getTicket();
            String getQueue();
            boolean getPassive();
            boolean getDurable();
            boolean getExclusive();
            boolean getAutoDelete();
            boolean getNowait();
            Map<String,Object> getArguments();

            // Builder for instances of Queue.Declare
            public static final class Builder
            {
                private int ticket = 0;
                private String queue = "";
                private boolean passive = false;
                private boolean durable = false;
                private boolean exclusive = false;
                private boolean autoDelete = false;
                private boolean nowait = false;
                private Map<String,Object> arguments = null;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder queue(String queue)
                {   this.queue = queue; return this; }
                public Builder passive(boolean passive)
                {   this.passive = passive; return this; }
                public Builder passive()
                {   return this.passive(true); }
                public Builder durable(boolean durable)
                {   this.durable = durable; return this; }
                public Builder durable()
                {   return this.durable(true); }
                public Builder exclusive(boolean exclusive)
                {   this.exclusive = exclusive; return this; }
                public Builder exclusive()
                {   return this.exclusive(true); }
                public Builder autoDelete(boolean autoDelete)
                {   this.autoDelete = autoDelete; return this; }
                public Builder autoDelete()
                {   return this.autoDelete(true); }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Builder arguments(Map<String,Object> arguments)
                {   this.arguments = arguments; return this; }
                public Declare build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.Declare(ticket, queue, passive, durable, exclusive, autoDelete, nowait, arguments);
                }
            }
        }
        public interface DeclareOk extends Method {
            String getQueue();
            int getMessageCount();
            int getConsumerCount();

            // Builder for instances of Queue.DeclareOk
            public static final class Builder
            {
                private String queue;
                private int messageCount;
                private int consumerCount;

                public Builder() { }

                public Builder queue(String queue)
                {   this.queue = queue; return this; }
                public Builder messageCount(int messageCount)
                {   this.messageCount = messageCount; return this; }
                public Builder consumerCount(int consumerCount)
                {   this.consumerCount = consumerCount; return this; }
                public DeclareOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.DeclareOk(queue, messageCount, consumerCount);
                }
            }
        }
        public interface Bind extends Method {
            int getTicket();
            String getQueue();
            String getExchange();
            String getRoutingKey();
            boolean getNowait();
            Map<String,Object> getArguments();

            // Builder for instances of Queue.Bind
            public static final class Builder
            {
                private int ticket = 0;
                private String queue = "";
                private String exchange;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String,Object> arguments = null;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder queue(String queue)
                {   this.queue = queue; return this; }
                public Builder exchange(String exchange)
                {   this.exchange = exchange; return this; }
                public Builder routingKey(String routingKey)
                {   this.routingKey = routingKey; return this; }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Builder arguments(Map<String,Object> arguments)
                {   this.arguments = arguments; return this; }
                public Bind build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.Bind(ticket, queue, exchange, routingKey, nowait, arguments);
                }
            }
        }
        public interface BindOk extends Method {

            // Builder for instances of Queue.BindOk
            public static final class Builder
            {

                public Builder() { }

                public BindOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.BindOk();
                }
            }
        }
        public interface Purge extends Method {
            int getTicket();
            String getQueue();
            boolean getNowait();

            // Builder for instances of Queue.Purge
            public static final class Builder
            {
                private int ticket = 0;
                private String queue = "";
                private boolean nowait = false;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder queue(String queue)
                {   this.queue = queue; return this; }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Purge build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.Purge(ticket, queue, nowait);
                }
            }
        }
        public interface PurgeOk extends Method {
            int getMessageCount();

            // Builder for instances of Queue.PurgeOk
            public static final class Builder
            {
                private int messageCount;

                public Builder() { }

                public Builder messageCount(int messageCount)
                {   this.messageCount = messageCount; return this; }
                public PurgeOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.PurgeOk(messageCount);
                }
            }
        }
        public interface Delete extends Method {
            int getTicket();
            String getQueue();
            boolean getIfUnused();
            boolean getIfEmpty();
            boolean getNowait();

            // Builder for instances of Queue.Delete
            public static final class Builder
            {
                private int ticket = 0;
                private String queue = "";
                private boolean ifUnused = false;
                private boolean ifEmpty = false;
                private boolean nowait = false;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder queue(String queue)
                {   this.queue = queue; return this; }
                public Builder ifUnused(boolean ifUnused)
                {   this.ifUnused = ifUnused; return this; }
                public Builder ifUnused()
                {   return this.ifUnused(true); }
                public Builder ifEmpty(boolean ifEmpty)
                {   this.ifEmpty = ifEmpty; return this; }
                public Builder ifEmpty()
                {   return this.ifEmpty(true); }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Delete build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.Delete(ticket, queue, ifUnused, ifEmpty, nowait);
                }
            }
        }
        public interface DeleteOk extends Method {
            int getMessageCount();

            // Builder for instances of Queue.DeleteOk
            public static final class Builder
            {
                private int messageCount;

                public Builder() { }

                public Builder messageCount(int messageCount)
                {   this.messageCount = messageCount; return this; }
                public DeleteOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.DeleteOk(messageCount);
                }
            }
        }
        public interface Unbind extends Method {
            int getTicket();
            String getQueue();
            String getExchange();
            String getRoutingKey();
            Map<String,Object> getArguments();

            // Builder for instances of Queue.Unbind
            public static final class Builder
            {
                private int ticket = 0;
                private String queue = "";
                private String exchange;
                private String routingKey = "";
                private Map<String,Object> arguments = null;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder queue(String queue)
                {   this.queue = queue; return this; }
                public Builder exchange(String exchange)
                {   this.exchange = exchange; return this; }
                public Builder routingKey(String routingKey)
                {   this.routingKey = routingKey; return this; }
                public Builder arguments(Map<String,Object> arguments)
                {   this.arguments = arguments; return this; }
                public Unbind build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.Unbind(ticket, queue, exchange, routingKey, arguments);
                }
            }
        }
        public interface UnbindOk extends Method {

            // Builder for instances of Queue.UnbindOk
            public static final class Builder
            {

                public Builder() { }

                public UnbindOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Queue.UnbindOk();
                }
            }
        }
    }

    public static class Basic {
        public interface Qos extends Method {
            int getPrefetchSize();
            int getPrefetchCount();
            boolean getGlobal();

            // Builder for instances of Basic.Qos
            public static final class Builder
            {
                private int prefetchSize = 0;
                private int prefetchCount = 0;
                private boolean global = false;

                public Builder() { }

                public Builder prefetchSize(int prefetchSize)
                {   this.prefetchSize = prefetchSize; return this; }
                public Builder prefetchCount(int prefetchCount)
                {   this.prefetchCount = prefetchCount; return this; }
                public Builder global(boolean global)
                {   this.global = global; return this; }
                public Builder global()
                {   return this.global(true); }
                public Qos build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Qos(prefetchSize, prefetchCount, global);
                }
            }
        }
        public interface QosOk extends Method {

            // Builder for instances of Basic.QosOk
            public static final class Builder
            {

                public Builder() { }

                public QosOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.QosOk();
                }
            }
        }
        public interface Consume extends Method {
            int getTicket();
            String getQueue();
            String getConsumerTag();
            boolean getNoLocal();
            boolean getNoAck();
            boolean getExclusive();
            boolean getNowait();
            Map<String,Object> getArguments();

            // Builder for instances of Basic.Consume
            public static final class Builder
            {
                private int ticket = 0;
                private String queue = "";
                private String consumerTag = "";
                private boolean noLocal = false;
                private boolean noAck = false;
                private boolean exclusive = false;
                private boolean nowait = false;
                private Map<String,Object> arguments = null;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder queue(String queue)
                {   this.queue = queue; return this; }
                public Builder consumerTag(String consumerTag)
                {   this.consumerTag = consumerTag; return this; }
                public Builder noLocal(boolean noLocal)
                {   this.noLocal = noLocal; return this; }
                public Builder noLocal()
                {   return this.noLocal(true); }
                public Builder noAck(boolean noAck)
                {   this.noAck = noAck; return this; }
                public Builder noAck()
                {   return this.noAck(true); }
                public Builder exclusive(boolean exclusive)
                {   this.exclusive = exclusive; return this; }
                public Builder exclusive()
                {   return this.exclusive(true); }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Builder arguments(Map<String,Object> arguments)
                {   this.arguments = arguments; return this; }
                public Consume build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Consume(ticket, queue, consumerTag, noLocal, noAck, exclusive, nowait, arguments);
                }
            }
        }
        public interface ConsumeOk extends Method {
            String getConsumerTag();

            // Builder for instances of Basic.ConsumeOk
            public static final class Builder
            {
                private String consumerTag;

                public Builder() { }

                public Builder consumerTag(String consumerTag)
                {   this.consumerTag = consumerTag; return this; }
                public ConsumeOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.ConsumeOk(consumerTag);
                }
            }
        }
        public interface Cancel extends Method {
            String getConsumerTag();
            boolean getNowait();

            // Builder for instances of Basic.Cancel
            public static final class Builder
            {
                private String consumerTag;
                private boolean nowait = false;

                public Builder() { }

                public Builder consumerTag(String consumerTag)
                {   this.consumerTag = consumerTag; return this; }
                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Cancel build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Cancel(consumerTag, nowait);
                }
            }
        }
        public interface CancelOk extends Method {
            String getConsumerTag();

            // Builder for instances of Basic.CancelOk
            public static final class Builder
            {
                private String consumerTag;

                public Builder() { }

                public Builder consumerTag(String consumerTag)
                {   this.consumerTag = consumerTag; return this; }
                public CancelOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.CancelOk(consumerTag);
                }
            }
        }
        public interface Publish extends Method {
            int getTicket();
            String getExchange();
            String getRoutingKey();
            boolean getMandatory();
            boolean getImmediate();

            // Builder for instances of Basic.Publish
            public static final class Builder
            {
                private int ticket = 0;
                private String exchange = "";
                private String routingKey = "";
                private boolean mandatory = false;
                private boolean immediate = false;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder exchange(String exchange)
                {   this.exchange = exchange; return this; }
                public Builder routingKey(String routingKey)
                {   this.routingKey = routingKey; return this; }
                public Builder mandatory(boolean mandatory)
                {   this.mandatory = mandatory; return this; }
                public Builder mandatory()
                {   return this.mandatory(true); }
                public Builder immediate(boolean immediate)
                {   this.immediate = immediate; return this; }
                public Builder immediate()
                {   return this.immediate(true); }
                public Publish build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Publish(ticket, exchange, routingKey, mandatory, immediate);
                }
            }
        }
        public interface Return extends Method {
            int getReplyCode();
            String getReplyText();
            String getExchange();
            String getRoutingKey();

            // Builder for instances of Basic.Return
            public static final class Builder
            {
                private int replyCode;
                private String replyText = "";
                private String exchange;
                private String routingKey;

                public Builder() { }

                public Builder replyCode(int replyCode)
                {   this.replyCode = replyCode; return this; }
                public Builder replyText(String replyText)
                {   this.replyText = replyText; return this; }
                public Builder exchange(String exchange)
                {   this.exchange = exchange; return this; }
                public Builder routingKey(String routingKey)
                {   this.routingKey = routingKey; return this; }
                public Return build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Return(replyCode, replyText, exchange, routingKey);
                }
            }
        }
        public interface Deliver extends Method {
            String getConsumerTag();
            long getDeliveryTag();
            boolean getRedelivered();
            String getExchange();
            String getRoutingKey();

            // Builder for instances of Basic.Deliver
            public static final class Builder
            {
                private String consumerTag;
                private long deliveryTag;
                private boolean redelivered = false;
                private String exchange;
                private String routingKey;

                public Builder() { }

                public Builder consumerTag(String consumerTag)
                {   this.consumerTag = consumerTag; return this; }
                public Builder deliveryTag(long deliveryTag)
                {   this.deliveryTag = deliveryTag; return this; }
                public Builder redelivered(boolean redelivered)
                {   this.redelivered = redelivered; return this; }
                public Builder redelivered()
                {   return this.redelivered(true); }
                public Builder exchange(String exchange)
                {   this.exchange = exchange; return this; }
                public Builder routingKey(String routingKey)
                {   this.routingKey = routingKey; return this; }
                public Deliver build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Deliver(consumerTag, deliveryTag, redelivered, exchange, routingKey);
                }
            }
        }
        public interface Get extends Method {
            int getTicket();
            String getQueue();
            boolean getNoAck();

            // Builder for instances of Basic.Get
            public static final class Builder
            {
                private int ticket = 0;
                private String queue = "";
                private boolean noAck = false;

                public Builder() { }

                public Builder ticket(int ticket)
                {   this.ticket = ticket; return this; }
                public Builder queue(String queue)
                {   this.queue = queue; return this; }
                public Builder noAck(boolean noAck)
                {   this.noAck = noAck; return this; }
                public Builder noAck()
                {   return this.noAck(true); }
                public Get build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Get(ticket, queue, noAck);
                }
            }
        }
        public interface GetOk extends Method {
            long getDeliveryTag();
            boolean getRedelivered();
            String getExchange();
            String getRoutingKey();
            int getMessageCount();

            // Builder for instances of Basic.GetOk
            public static final class Builder
            {
                private long deliveryTag;
                private boolean redelivered = false;
                private String exchange;
                private String routingKey;
                private int messageCount;

                public Builder() { }

                public Builder deliveryTag(long deliveryTag)
                {   this.deliveryTag = deliveryTag; return this; }
                public Builder redelivered(boolean redelivered)
                {   this.redelivered = redelivered; return this; }
                public Builder redelivered()
                {   return this.redelivered(true); }
                public Builder exchange(String exchange)
                {   this.exchange = exchange; return this; }
                public Builder routingKey(String routingKey)
                {   this.routingKey = routingKey; return this; }
                public Builder messageCount(int messageCount)
                {   this.messageCount = messageCount; return this; }
                public GetOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.GetOk(deliveryTag, redelivered, exchange, routingKey, messageCount);
                }
            }
        }
        public interface GetEmpty extends Method {
            String getClusterId();

            // Builder for instances of Basic.GetEmpty
            public static final class Builder
            {
                private String clusterId = "";

                public Builder() { }

                public Builder clusterId(String clusterId)
                {   this.clusterId = clusterId; return this; }
                public GetEmpty build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.GetEmpty(clusterId);
                }
            }
        }
        public interface Ack extends Method {
            long getDeliveryTag();
            boolean getMultiple();

            // Builder for instances of Basic.Ack
            public static final class Builder
            {
                private long deliveryTag = 0L;
                private boolean multiple = false;

                public Builder() { }

                public Builder deliveryTag(long deliveryTag)
                {   this.deliveryTag = deliveryTag; return this; }
                public Builder multiple(boolean multiple)
                {   this.multiple = multiple; return this; }
                public Builder multiple()
                {   return this.multiple(true); }
                public Ack build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Ack(deliveryTag, multiple);
                }
            }
        }
        public interface Reject extends Method {
            long getDeliveryTag();
            boolean getRequeue();

            // Builder for instances of Basic.Reject
            public static final class Builder
            {
                private long deliveryTag;
                private boolean requeue = true;

                public Builder() { }

                public Builder deliveryTag(long deliveryTag)
                {   this.deliveryTag = deliveryTag; return this; }
                public Builder requeue(boolean requeue)
                {   this.requeue = requeue; return this; }
                public Builder requeue()
                {   return this.requeue(true); }
                public Reject build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Reject(deliveryTag, requeue);
                }
            }
        }
        public interface RecoverAsync extends Method {
            boolean getRequeue();

            // Builder for instances of Basic.RecoverAsync
            public static final class Builder
            {
                private boolean requeue = false;

                public Builder() { }

                public Builder requeue(boolean requeue)
                {   this.requeue = requeue; return this; }
                public Builder requeue()
                {   return this.requeue(true); }
                public RecoverAsync build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.RecoverAsync(requeue);
                }
            }
        }
        public interface Recover extends Method {
            boolean getRequeue();

            // Builder for instances of Basic.Recover
            public static final class Builder
            {
                private boolean requeue = false;

                public Builder() { }

                public Builder requeue(boolean requeue)
                {   this.requeue = requeue; return this; }
                public Builder requeue()
                {   return this.requeue(true); }
                public Recover build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Recover(requeue);
                }
            }
        }
        public interface RecoverOk extends Method {

            // Builder for instances of Basic.RecoverOk
            public static final class Builder
            {

                public Builder() { }

                public RecoverOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.RecoverOk();
                }
            }
        }
        public interface Nack extends Method {
            long getDeliveryTag();
            boolean getMultiple();
            boolean getRequeue();

            // Builder for instances of Basic.Nack
            public static final class Builder
            {
                private long deliveryTag = 0L;
                private boolean multiple = false;
                private boolean requeue = true;

                public Builder() { }

                public Builder deliveryTag(long deliveryTag)
                {   this.deliveryTag = deliveryTag; return this; }
                public Builder multiple(boolean multiple)
                {   this.multiple = multiple; return this; }
                public Builder multiple()
                {   return this.multiple(true); }
                public Builder requeue(boolean requeue)
                {   this.requeue = requeue; return this; }
                public Builder requeue()
                {   return this.requeue(true); }
                public Nack build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Basic.Nack(deliveryTag, multiple, requeue);
                }
            }
        }
    }

    public static class Tx {
        public interface Select extends Method {

            // Builder for instances of Tx.Select
            public static final class Builder
            {

                public Builder() { }

                public Select build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Tx.Select();
                }
            }
        }
        public interface SelectOk extends Method {

            // Builder for instances of Tx.SelectOk
            public static final class Builder
            {

                public Builder() { }

                public SelectOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Tx.SelectOk();
                }
            }
        }
        public interface Commit extends Method {

            // Builder for instances of Tx.Commit
            public static final class Builder
            {

                public Builder() { }

                public Commit build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Tx.Commit();
                }
            }
        }
        public interface CommitOk extends Method {

            // Builder for instances of Tx.CommitOk
            public static final class Builder
            {

                public Builder() { }

                public CommitOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Tx.CommitOk();
                }
            }
        }
        public interface Rollback extends Method {

            // Builder for instances of Tx.Rollback
            public static final class Builder
            {

                public Builder() { }

                public Rollback build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Tx.Rollback();
                }
            }
        }
        public interface RollbackOk extends Method {

            // Builder for instances of Tx.RollbackOk
            public static final class Builder
            {

                public Builder() { }

                public RollbackOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Tx.RollbackOk();
                }
            }
        }
    }

    public static class Confirm {
        public interface Select extends Method {
            boolean getNowait();

            // Builder for instances of Confirm.Select
            public static final class Builder
            {
                private boolean nowait = false;

                public Builder() { }

                public Builder nowait(boolean nowait)
                {   this.nowait = nowait; return this; }
                public Builder nowait()
                {   return this.nowait(true); }
                public Select build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Confirm.Select(nowait);
                }
            }
        }
        public interface SelectOk extends Method {

            // Builder for instances of Confirm.SelectOk
            public static final class Builder
            {

                public Builder() { }

                public SelectOk build() {
                    return new com.rabbitmq.client.impl.AMQImpl.Confirm.SelectOk();
                }
            }
        }
    }

    public static class BasicProperties extends com.rabbitmq.client.impl.AMQBasicProperties {
        private String contentType;
        private String contentEncoding;
        private Map<String,Object> headers;
        private Integer deliveryMode;
        private Integer priority;
        private String correlationId;
        private String replyTo;
        private String expiration;
        private String messageId;
        private Date timestamp;
        private String type;
        private String userId;
        private String appId;
        private String clusterId;

        public BasicProperties(
            String contentType,
            String contentEncoding,
            Map<String,Object> headers,
            Integer deliveryMode,
            Integer priority,
            String correlationId,
            String replyTo,
            String expiration,
            String messageId,
            Date timestamp,
            String type,
            String userId,
            String appId,
            String clusterId)
        {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.headers = headers==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(headers));
            this.deliveryMode = deliveryMode;
            this.priority = priority;
            this.correlationId = correlationId;
            this.replyTo = replyTo;
            this.expiration = expiration;
            this.messageId = messageId;
            this.timestamp = timestamp;
            this.type = type;
            this.userId = userId;
            this.appId = appId;
            this.clusterId = clusterId;
        }

        public BasicProperties(DataInputStream in) throws IOException {
            super(in);
            ContentHeaderPropertyReader reader = new ContentHeaderPropertyReader(in);
            boolean contentType_present = reader.readPresence();
            boolean contentEncoding_present = reader.readPresence();
            boolean headers_present = reader.readPresence();
            boolean deliveryMode_present = reader.readPresence();
            boolean priority_present = reader.readPresence();
            boolean correlationId_present = reader.readPresence();
            boolean replyTo_present = reader.readPresence();
            boolean expiration_present = reader.readPresence();
            boolean messageId_present = reader.readPresence();
            boolean timestamp_present = reader.readPresence();
            boolean type_present = reader.readPresence();
            boolean userId_present = reader.readPresence();
            boolean appId_present = reader.readPresence();
            boolean clusterId_present = reader.readPresence();

            reader.finishPresence();

            this.contentType = contentType_present ? reader.readShortstr() : null;
            this.contentEncoding = contentEncoding_present ? reader.readShortstr() : null;
            this.headers = headers_present ? reader.readTable() : null;
            this.deliveryMode = deliveryMode_present ? reader.readOctet() : null;
            this.priority = priority_present ? reader.readOctet() : null;
            this.correlationId = correlationId_present ? reader.readShortstr() : null;
            this.replyTo = replyTo_present ? reader.readShortstr() : null;
            this.expiration = expiration_present ? reader.readShortstr() : null;
            this.messageId = messageId_present ? reader.readShortstr() : null;
            this.timestamp = timestamp_present ? reader.readTimestamp() : null;
            this.type = type_present ? reader.readShortstr() : null;
            this.userId = userId_present ? reader.readShortstr() : null;
            this.appId = appId_present ? reader.readShortstr() : null;
            this.clusterId = clusterId_present ? reader.readShortstr() : null;
        }
        public BasicProperties() {}
        public int getClassId() { return 60; }
        public String getClassName() { return "basic"; }

        public Builder builder() {
            Builder builder = new Builder()
                .contentType(contentType)
                .contentEncoding(contentEncoding)
                .headers(headers)
                .deliveryMode(deliveryMode)
                .priority(priority)
                .correlationId(correlationId)
                .replyTo(replyTo)
                .expiration(expiration)
                .messageId(messageId)
                .timestamp(timestamp)
                .type(type)
                .userId(userId)
                .appId(appId)
                .clusterId(clusterId);
            return builder;
        }

        public String getContentType() { return this.contentType; }
        public String getContentEncoding() { return this.contentEncoding; }
        public Map<String,Object> getHeaders() { return this.headers; }
        public Integer getDeliveryMode() { return this.deliveryMode; }
        public Integer getPriority() { return this.priority; }
        public String getCorrelationId() { return this.correlationId; }
        public String getReplyTo() { return this.replyTo; }
        public String getExpiration() { return this.expiration; }
        public String getMessageId() { return this.messageId; }
        public Date getTimestamp() { return this.timestamp; }
        public String getType() { return this.type; }
        public String getUserId() { return this.userId; }
        public String getAppId() { return this.appId; }
        public String getClusterId() { return this.clusterId; }

        public void writePropertiesTo(ContentHeaderPropertyWriter writer)
            throws IOException
        {
            writer.writePresence(this.contentType != null);
            writer.writePresence(this.contentEncoding != null);
            writer.writePresence(this.headers != null);
            writer.writePresence(this.deliveryMode != null);
            writer.writePresence(this.priority != null);
            writer.writePresence(this.correlationId != null);
            writer.writePresence(this.replyTo != null);
            writer.writePresence(this.expiration != null);
            writer.writePresence(this.messageId != null);
            writer.writePresence(this.timestamp != null);
            writer.writePresence(this.type != null);
            writer.writePresence(this.userId != null);
            writer.writePresence(this.appId != null);
            writer.writePresence(this.clusterId != null);

            writer.finishPresence();

            if (this.contentType != null) writer.writeShortstr(this.contentType);
            if (this.contentEncoding != null) writer.writeShortstr(this.contentEncoding);
            if (this.headers != null) writer.writeTable(this.headers);
            if (this.deliveryMode != null) writer.writeOctet(this.deliveryMode);
            if (this.priority != null) writer.writeOctet(this.priority);
            if (this.correlationId != null) writer.writeShortstr(this.correlationId);
            if (this.replyTo != null) writer.writeShortstr(this.replyTo);
            if (this.expiration != null) writer.writeShortstr(this.expiration);
            if (this.messageId != null) writer.writeShortstr(this.messageId);
            if (this.timestamp != null) writer.writeTimestamp(this.timestamp);
            if (this.type != null) writer.writeShortstr(this.type);
            if (this.userId != null) writer.writeShortstr(this.userId);
            if (this.appId != null) writer.writeShortstr(this.appId);
            if (this.clusterId != null) writer.writeShortstr(this.clusterId);
        }

        public void appendPropertyDebugStringTo(StringBuilder acc) {
            acc.append("(content-type=")
               .append(this.contentType)
               .append(", content-encoding=")
               .append(this.contentEncoding)
               .append(", headers=")
               .append(this.headers)
               .append(", delivery-mode=")
               .append(this.deliveryMode)
               .append(", priority=")
               .append(this.priority)
               .append(", correlation-id=")
               .append(this.correlationId)
               .append(", reply-to=")
               .append(this.replyTo)
               .append(", expiration=")
               .append(this.expiration)
               .append(", message-id=")
               .append(this.messageId)
               .append(", timestamp=")
               .append(this.timestamp)
               .append(", type=")
               .append(this.type)
               .append(", user-id=")
               .append(this.userId)
               .append(", app-id=")
               .append(this.appId)
               .append(", cluster-id=")
               .append(this.clusterId)
               .append(")");
        }

        public static final class Builder {
            private String contentType;
            private String contentEncoding;
            private Map<String,Object> headers;
            private Integer deliveryMode;
            private Integer priority;
            private String correlationId;
            private String replyTo;
            private String expiration;
            private String messageId;
            private Date timestamp;
            private String type;
            private String userId;
            private String appId;
            private String clusterId;

            public Builder() {};

            public Builder contentType(String contentType)
            {   this.contentType = contentType; return this; }
            public Builder contentEncoding(String contentEncoding)
            {   this.contentEncoding = contentEncoding; return this; }
            public Builder headers(Map<String,Object> headers)
            {   this.headers = headers; return this; }
            public Builder deliveryMode(Integer deliveryMode)
            {   this.deliveryMode = deliveryMode; return this; }
            public Builder priority(Integer priority)
            {   this.priority = priority; return this; }
            public Builder correlationId(String correlationId)
            {   this.correlationId = correlationId; return this; }
            public Builder replyTo(String replyTo)
            {   this.replyTo = replyTo; return this; }
            public Builder expiration(String expiration)
            {   this.expiration = expiration; return this; }
            public Builder messageId(String messageId)
            {   this.messageId = messageId; return this; }
            public Builder timestamp(Date timestamp)
            {   this.timestamp = timestamp; return this; }
            public Builder type(String type)
            {   this.type = type; return this; }
            public Builder userId(String userId)
            {   this.userId = userId; return this; }
            public Builder appId(String appId)
            {   this.appId = appId; return this; }
            public Builder clusterId(String clusterId)
            {   this.clusterId = clusterId; return this; }

            public BasicProperties build() {
                return new BasicProperties
                    ( contentType
                    , contentEncoding
                    , headers
                    , deliveryMode
                    , priority
                    , correlationId
                    , replyTo
                    , expiration
                    , messageId
                    , timestamp
                    , type
                    , userId
                    , appId
                    , clusterId
                    );
            }
        }
    }
}
