/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.TopologyRecoveryException;
import java.io.IOException;
import java.net.ConnectException;

public class ForgivingExceptionHandler
implements ExceptionHandler {
    @Override
    public void handleUnexpectedConnectionDriverException(Connection conn, Throwable exception) {
    }

    @Override
    public void handleReturnListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ReturnListener.handleReturn");
    }

    @Override
    public void handleFlowListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "FlowListener.handleFlow");
    }

    @Override
    public void handleConfirmListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ConfirmListener.handle{N,A}ck");
    }

    @Override
    public void handleBlockedListenerException(Connection connection, Throwable exception) {
        this.handleConnectionKiller(connection, exception, "BlockedListener");
    }

    @Override
    public void handleConsumerException(Channel channel, Throwable exception, Consumer consumer, String consumerTag, String methodName) {
        this.handleChannelKiller(channel, exception, "Consumer " + consumer + " (" + consumerTag + ")" + " method " + methodName + " for channel " + channel);
    }

    @Override
    public void handleConnectionRecoveryException(Connection conn, Throwable exception) {
        if (!(exception instanceof ConnectException)) {
            System.err.println("Caught an exception during connection recovery!");
            exception.printStackTrace(System.err);
        }
    }

    @Override
    public void handleChannelRecoveryException(Channel ch, Throwable exception) {
        System.err.println("Caught an exception when recovering channel " + ch.getChannelNumber());
        exception.printStackTrace(System.err);
    }

    @Override
    public void handleTopologyRecoveryException(Connection conn, Channel ch, TopologyRecoveryException exception) {
        System.err.println("Caught an exception when recovering topology " + exception.getMessage());
        exception.printStackTrace(System.err);
    }

    protected void handleChannelKiller(Channel channel, Throwable exception, String what) {
        System.err.println(this.getClass().getName() + ": " + what + " threw an exception for channel " + channel + ":");
        exception.printStackTrace();
    }

    protected void handleConnectionKiller(Connection connection, Throwable exception, String what) {
        System.err.println("DefaultExceptionHandler: " + what + " threw an exception for connection " + connection + ":");
        exception.printStackTrace();
        try {
            connection.close(200, "Closed due to exception from " + what);
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        catch (IOException ioe) {
            System.err.println("Failure during close of connection " + connection + " after " + exception + ":");
            ioe.printStackTrace();
            connection.abort(541, "Internal error closing connection for " + what);
        }
    }
}

