/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.recovery;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.RecoverableChannel;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.rabbitmq.client.impl.recovery.RecordedConsumer;
import com.rabbitmq.client.impl.recovery.RecordedExchange;
import com.rabbitmq.client.impl.recovery.RecordedQueue;
import com.rabbitmq.client.impl.recovery.RecoveryAwareChannelN;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;

public class AutorecoveringChannel
implements RecoverableChannel {
    private volatile RecoveryAwareChannelN delegate;
    private volatile AutorecoveringConnection connection;
    private final List<ShutdownListener> shutdownHooks = new CopyOnWriteArrayList<ShutdownListener>();
    private final List<RecoveryListener> recoveryListeners = new CopyOnWriteArrayList<RecoveryListener>();
    private final List<ReturnListener> returnListeners = new CopyOnWriteArrayList<ReturnListener>();
    private final List<ConfirmListener> confirmListeners = new CopyOnWriteArrayList<ConfirmListener>();
    private final List<FlowListener> flowListeners = new CopyOnWriteArrayList<FlowListener>();
    private final Set<String> consumerTags = Collections.synchronizedSet(new HashSet());
    private int prefetchCountConsumer;
    private int prefetchCountGlobal;
    private boolean usesPublisherConfirms;
    private boolean usesTransactions;

    public AutorecoveringChannel(AutorecoveringConnection connection, RecoveryAwareChannelN delegate) {
        this.connection = connection;
        this.delegate = delegate;
    }

    @Override
    public int getChannelNumber() {
        return this.delegate.getChannelNumber();
    }

    @Override
    public Connection getConnection() {
        return this.delegate.getConnection();
    }

    public Channel getDelegate() {
        return this.delegate;
    }

    @Override
    public void close() throws IOException, TimeoutException {
        try {
            this.delegate.close();
        }
        finally {
            for (String consumerTag : this.consumerTags) {
                this.connection.deleteRecordedConsumer(consumerTag);
            }
            this.connection.unregisterChannel(this);
        }
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException, TimeoutException {
        try {
            this.delegate.close(closeCode, closeMessage);
        }
        finally {
            this.connection.unregisterChannel(this);
        }
    }

    @Override
    @Deprecated
    public boolean flowBlocked() {
        return this.delegate.flowBlocked();
    }

    @Override
    public void abort() throws IOException {
        this.delegate.abort();
    }

    @Override
    public void abort(int closeCode, String closeMessage) throws IOException {
        this.delegate.abort(closeCode, closeMessage);
    }

    @Override
    public void addReturnListener(ReturnListener listener) {
        this.returnListeners.add(listener);
        this.delegate.addReturnListener(listener);
    }

    @Override
    public boolean removeReturnListener(ReturnListener listener) {
        this.returnListeners.remove(listener);
        return this.delegate.removeReturnListener(listener);
    }

    @Override
    public void clearReturnListeners() {
        this.returnListeners.clear();
        this.delegate.clearReturnListeners();
    }

    @Override
    @Deprecated
    public void addFlowListener(FlowListener listener) {
        this.flowListeners.add(listener);
        this.delegate.addFlowListener(listener);
    }

    @Override
    @Deprecated
    public boolean removeFlowListener(FlowListener listener) {
        this.flowListeners.remove(listener);
        return this.delegate.removeFlowListener(listener);
    }

    @Override
    @Deprecated
    public void clearFlowListeners() {
        this.flowListeners.clear();
        this.delegate.clearFlowListeners();
    }

    @Override
    public void addConfirmListener(ConfirmListener listener) {
        this.confirmListeners.add(listener);
        this.delegate.addConfirmListener(listener);
    }

    @Override
    public boolean removeConfirmListener(ConfirmListener listener) {
        this.confirmListeners.remove(listener);
        return this.delegate.removeConfirmListener(listener);
    }

    @Override
    public void clearConfirmListeners() {
        this.confirmListeners.clear();
        this.delegate.clearConfirmListeners();
    }

    @Override
    public Consumer getDefaultConsumer() {
        return this.delegate.getDefaultConsumer();
    }

    @Override
    public void setDefaultConsumer(Consumer consumer) {
        this.delegate.setDefaultConsumer(consumer);
    }

    @Override
    public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
        if (global) {
            this.prefetchCountGlobal = prefetchCount;
        } else {
            this.prefetchCountConsumer = prefetchCount;
        }
        this.delegate.basicQos(prefetchSize, prefetchCount, global);
    }

    @Override
    public void basicQos(int prefetchCount) throws IOException {
        this.basicQos(0, prefetchCount, false);
    }

    @Override
    public void basicQos(int prefetchCount, boolean global) throws IOException {
        this.basicQos(0, prefetchCount, global);
    }

    @Override
    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, props, body);
    }

    @Override
    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, mandatory, props, body);
    }

    @Override
    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, mandatory, immediate, props, body);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
        return this.exchangeDeclare(exchange, type, false, false, null);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type) throws IOException {
        return this.exchangeDeclare(exchange, type.getType());
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, false, null);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable) throws IOException {
        return this.exchangeDeclare(exchange, type.getType(), durable);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, autoDelete, false, arguments);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.exchangeDeclare(exchange, type.getType(), durable, autoDelete, arguments);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        AMQP.Exchange.DeclareOk ok = this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, (Map)arguments);
        RecordedExchange x = new RecordedExchange(this, exchange).type(type).durable(durable).autoDelete(autoDelete).arguments(arguments);
        this.recordExchange(exchange, x);
        return ok;
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return this.exchangeDeclare(exchange, type.getType(), durable, autoDelete, internal, arguments);
    }

    @Override
    public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        RecordedExchange x = new RecordedExchange(this, exchange).type(type).durable(durable).autoDelete(autoDelete).arguments(arguments);
        this.recordExchange(exchange, x);
        this.delegate.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments);
    }

    @Override
    public void exchangeDeclareNoWait(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        this.exchangeDeclareNoWait(exchange, type.getType(), durable, autoDelete, internal, arguments);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) throws IOException {
        return this.delegate.exchangeDeclarePassive(name);
    }

    @Override
    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
        this.deleteRecordedExchange(exchange);
        return this.delegate.exchangeDelete(exchange, ifUnused);
    }

    @Override
    public void exchangeDeleteNoWait(String exchange, boolean ifUnused) throws IOException {
        this.deleteRecordedExchange(exchange);
        this.delegate.exchangeDeleteNoWait(exchange, ifUnused);
    }

    @Override
    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
        return this.exchangeDelete(exchange, false);
    }

    @Override
    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) throws IOException {
        return this.exchangeBind(destination, source, routingKey, null);
    }

    @Override
    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        AMQP.Exchange.BindOk ok = this.delegate.exchangeBind(destination, source, routingKey, (Map)arguments);
        this.recordExchangeBinding(destination, source, routingKey, arguments);
        return ok;
    }

    @Override
    public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeBindNoWait(destination, source, routingKey, arguments);
        this.recordExchangeBinding(destination, source, routingKey, arguments);
    }

    @Override
    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) throws IOException {
        return this.exchangeUnbind(destination, source, routingKey, null);
    }

    @Override
    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.deleteRecordedExchangeBinding(destination, source, routingKey, arguments);
        this.maybeDeleteRecordedAutoDeleteExchange(source);
        return this.delegate.exchangeUnbind(destination, source, routingKey, (Map)arguments);
    }

    @Override
    public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeUnbindNoWait(destination, source, routingKey, arguments);
        this.deleteRecordedExchangeBinding(destination, source, routingKey, arguments);
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.queueDeclare("", false, true, true, null);
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        AMQP.Queue.DeclareOk ok = this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, (Map)arguments);
        RecordedQueue q = new RecordedQueue(this, ok.getQueue()).durable(durable).exclusive(exclusive).autoDelete(autoDelete).arguments(arguments);
        if (queue.equals("")) {
            q.serverNamed(true);
        }
        this.recordQueue(ok, q);
        return ok;
    }

    @Override
    public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        RecordedQueue meta = new RecordedQueue(this, queue).durable(durable).exclusive(exclusive).autoDelete(autoDelete).arguments(arguments);
        this.delegate.queueDeclareNoWait(queue, durable, exclusive, autoDelete, arguments);
        this.recordQueue(queue, meta);
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
        return this.delegate.queueDeclarePassive(queue);
    }

    @Override
    public long messageCount(String queue) throws IOException {
        return this.delegate.messageCount(queue);
    }

    @Override
    public long consumerCount(String queue) throws IOException {
        return this.delegate.consumerCount(queue);
    }

    @Override
    public AMQP.Queue.DeleteOk queueDelete(String queue) throws IOException {
        return this.queueDelete(queue, false, false);
    }

    @Override
    public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        this.deleteRecordedQueue(queue);
        return this.delegate.queueDelete(queue, ifUnused, ifEmpty);
    }

    @Override
    public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        this.deleteRecordedQueue(queue);
        this.delegate.queueDeleteNoWait(queue, ifUnused, ifEmpty);
    }

    @Override
    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
        return this.queueBind(queue, exchange, routingKey, null);
    }

    @Override
    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        AMQP.Queue.BindOk ok = this.delegate.queueBind(queue, exchange, routingKey, (Map)arguments);
        this.recordQueueBinding(queue, exchange, routingKey, arguments);
        return ok;
    }

    @Override
    public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.queueBindNoWait(queue, exchange, routingKey, arguments);
        this.recordQueueBinding(queue, exchange, routingKey, arguments);
    }

    @Override
    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
        return this.queueUnbind(queue, exchange, routingKey, null);
    }

    @Override
    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        this.deleteRecordedQueueBinding(queue, exchange, routingKey, arguments);
        this.maybeDeleteRecordedAutoDeleteExchange(exchange);
        return this.delegate.queueUnbind(queue, exchange, routingKey, (Map)arguments);
    }

    @Override
    public AMQP.Queue.PurgeOk queuePurge(String queue) throws IOException {
        return this.delegate.queuePurge(queue);
    }

    @Override
    public GetResponse basicGet(String queue, boolean autoAck) throws IOException {
        return this.delegate.basicGet(queue, autoAck);
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        this.delegate.basicAck(deliveryTag, multiple);
    }

    @Override
    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
        this.delegate.basicNack(deliveryTag, multiple, requeue);
    }

    @Override
    public void basicReject(long deliveryTag, boolean requeue) throws IOException {
        this.delegate.basicReject(deliveryTag, requeue);
    }

    @Override
    public String basicConsume(String queue, Consumer callback) throws IOException {
        return this.basicConsume(queue, false, callback);
    }

    @Override
    public String basicConsume(String queue, boolean autoAck, Consumer callback) throws IOException {
        return this.basicConsume(queue, autoAck, "", callback);
    }

    @Override
    public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) throws IOException {
        return this.basicConsume(queue, autoAck, consumerTag, false, false, null, callback);
    }

    @Override
    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, Consumer callback) throws IOException {
        return this.basicConsume(queue, autoAck, "", false, false, arguments, callback);
    }

    @Override
    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) throws IOException {
        String result = this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, callback);
        this.recordConsumer(result, queue, autoAck, exclusive, arguments, callback);
        return result;
    }

    @Override
    public void basicCancel(String consumerTag) throws IOException {
        RecordedConsumer c = this.deleteRecordedConsumer(consumerTag);
        if (c != null) {
            this.maybeDeleteRecordedAutoDeleteQueue(c.getQueue());
        }
        this.delegate.basicCancel(consumerTag);
    }

    @Override
    public AMQP.Basic.RecoverOk basicRecover() throws IOException {
        return this.delegate.basicRecover();
    }

    @Override
    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
        return this.delegate.basicRecover(requeue);
    }

    @Override
    public AMQP.Tx.SelectOk txSelect() throws IOException {
        this.usesTransactions = true;
        return this.delegate.txSelect();
    }

    @Override
    public AMQP.Tx.CommitOk txCommit() throws IOException {
        return this.delegate.txCommit();
    }

    @Override
    public AMQP.Tx.RollbackOk txRollback() throws IOException {
        return this.delegate.txRollback();
    }

    @Override
    public AMQP.Confirm.SelectOk confirmSelect() throws IOException {
        this.usesPublisherConfirms = true;
        return this.delegate.confirmSelect();
    }

    @Override
    public long getNextPublishSeqNo() {
        return this.delegate.getNextPublishSeqNo();
    }

    @Override
    public boolean waitForConfirms() throws InterruptedException {
        return this.delegate.waitForConfirms();
    }

    @Override
    public boolean waitForConfirms(long timeout) throws InterruptedException, TimeoutException {
        return this.delegate.waitForConfirms(timeout);
    }

    @Override
    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        this.delegate.waitForConfirmsOrDie();
    }

    @Override
    public void waitForConfirmsOrDie(long timeout) throws IOException, InterruptedException, TimeoutException {
        this.delegate.waitForConfirmsOrDie(timeout);
    }

    @Override
    public void asyncRpc(Method method) throws IOException {
        this.delegate.asyncRpc(method);
    }

    @Override
    public Command rpc(Method method) throws IOException {
        return this.delegate.rpc(method);
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownHooks.add(listener);
        this.delegate.addShutdownListener(listener);
    }

    @Override
    public void removeShutdownListener(ShutdownListener listener) {
        this.shutdownHooks.remove(listener);
        this.delegate.removeShutdownListener(listener);
    }

    @Override
    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    @Override
    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void addRecoveryListener(RecoveryListener listener) {
        this.recoveryListeners.add(listener);
    }

    @Override
    public void removeRecoveryListener(RecoveryListener listener) {
        this.recoveryListeners.remove(listener);
    }

    public void automaticallyRecover(AutorecoveringConnection connection, Connection connDelegate) throws IOException {
        RecoveryAwareChannelN defunctChannel = this.delegate;
        this.connection = connection;
        RecoveryAwareChannelN newChannel = (RecoveryAwareChannelN)connDelegate.createChannel(this.getChannelNumber());
        if (newChannel == null) {
            throw new IOException("Failed to create new channel for channel number=" + this.getChannelNumber() + " during recovery");
        }
        this.delegate = newChannel;
        this.delegate.inheritOffsetFrom(defunctChannel);
        this.notifyRecoveryListenersStarted();
        this.recoverShutdownListeners();
        this.recoverReturnListeners();
        this.recoverConfirmListeners();
        this.recoverFlowListeners();
        this.recoverState();
        this.notifyRecoveryListenersComplete();
    }

    private void recoverShutdownListeners() {
        for (ShutdownListener sh : this.shutdownHooks) {
            this.delegate.addShutdownListener(sh);
        }
    }

    private void recoverReturnListeners() {
        for (ReturnListener rl : this.returnListeners) {
            this.delegate.addReturnListener(rl);
        }
    }

    private void recoverConfirmListeners() {
        for (ConfirmListener cl : this.confirmListeners) {
            this.delegate.addConfirmListener(cl);
        }
    }

    @Deprecated
    private void recoverFlowListeners() {
        for (FlowListener fl : this.flowListeners) {
            this.delegate.addFlowListener(fl);
        }
    }

    private void recoverState() throws IOException {
        if (this.prefetchCountConsumer != 0) {
            this.basicQos(this.prefetchCountConsumer, false);
        }
        if (this.prefetchCountGlobal != 0) {
            this.basicQos(this.prefetchCountGlobal, true);
        }
        if (this.usesPublisherConfirms) {
            this.confirmSelect();
        }
        if (this.usesTransactions) {
            this.txSelect();
        }
    }

    private void notifyRecoveryListenersComplete() {
        for (RecoveryListener f : this.recoveryListeners) {
            f.handleRecovery(this);
        }
    }

    private void notifyRecoveryListenersStarted() {
        for (RecoveryListener f : this.recoveryListeners) {
            f.handleRecoveryStarted(this);
        }
    }

    private void recordQueueBinding(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.connection.recordQueueBinding(this, queue, exchange, routingKey, arguments);
    }

    private boolean deleteRecordedQueueBinding(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return this.connection.deleteRecordedQueueBinding(this, queue, exchange, routingKey, arguments);
    }

    private void recordExchangeBinding(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.connection.recordExchangeBinding(this, destination, source, routingKey, arguments);
    }

    private boolean deleteRecordedExchangeBinding(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return this.connection.deleteRecordedExchangeBinding(this, destination, source, routingKey, arguments);
    }

    private void recordQueue(AMQP.Queue.DeclareOk ok, RecordedQueue q) {
        this.connection.recordQueue(ok, q);
    }

    private void recordQueue(String queue, RecordedQueue meta) {
        this.connection.recordQueue(queue, meta);
    }

    private void deleteRecordedQueue(String queue) {
        this.connection.deleteRecordedQueue(queue);
    }

    private void recordExchange(String exchange, RecordedExchange x) {
        this.connection.recordExchange(exchange, x);
    }

    private void deleteRecordedExchange(String exchange) {
        this.connection.deleteRecordedExchange(exchange);
    }

    private void recordConsumer(String result, String queue, boolean autoAck, boolean exclusive, Map<String, Object> arguments, Consumer callback) {
        RecordedConsumer consumer = new RecordedConsumer(this, queue).autoAck(autoAck).consumerTag(result).exclusive(exclusive).arguments(arguments).consumer(callback);
        this.consumerTags.add(result);
        this.connection.recordConsumer(result, consumer);
    }

    private RecordedConsumer deleteRecordedConsumer(String consumerTag) {
        this.consumerTags.remove(consumerTag);
        return this.connection.deleteRecordedConsumer(consumerTag);
    }

    private void maybeDeleteRecordedAutoDeleteQueue(String queue) {
        this.connection.maybeDeleteRecordedAutoDeleteQueue(queue);
    }

    private void maybeDeleteRecordedAutoDeleteExchange(String exchange) {
        this.connection.maybeDeleteRecordedAutoDeleteExchange(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConsumerTag(String tag, String newTag) {
        Set<String> set = this.consumerTags;
        synchronized (set) {
            this.consumerTags.remove(tag);
            this.consumerTags.add(newTag);
        }
    }
}

