/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.impl.AbstractMetricsCollector;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

public class MicrometerMetricsCollector
extends AbstractMetricsCollector {
    private final AtomicLong connections;
    private final AtomicLong channels;
    private final Counter publishedMessages;
    private final Counter consumedMessages;
    private final Counter acknowledgedMessages;
    private final Counter rejectedMessages;

    public MicrometerMetricsCollector(MeterRegistry registry) {
        this(registry, "rabbitmq");
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix) {
        this(registry, prefix, new String[0]);
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix, String ... tags) {
        this(registry, prefix, Tags.zip((String[])tags));
    }

    public MicrometerMetricsCollector(final MeterRegistry registry, final String prefix, final Iterable<Tag> tags) {
        this(new MetricsCreator(){

            @Override
            public Object create(Metrics metric) {
                return metric.create(registry, prefix, tags);
            }
        });
    }

    public MicrometerMetricsCollector(MetricsCreator creator) {
        this.connections = (AtomicLong)creator.create(Metrics.CONNECTIONS);
        this.channels = (AtomicLong)creator.create(Metrics.CHANNELS);
        this.publishedMessages = (Counter)creator.create(Metrics.PUBLISHED_MESSAGES);
        this.consumedMessages = (Counter)creator.create(Metrics.CONSUMED_MESSAGES);
        this.acknowledgedMessages = (Counter)creator.create(Metrics.ACKNOWLEDGED_MESSAGES);
        this.rejectedMessages = (Counter)creator.create(Metrics.REJECTED_MESSAGES);
    }

    @Override
    protected void incrementConnectionCount(Connection connection) {
        this.connections.incrementAndGet();
    }

    @Override
    protected void decrementConnectionCount(Connection connection) {
        this.connections.decrementAndGet();
    }

    @Override
    protected void incrementChannelCount(Channel channel) {
        this.channels.incrementAndGet();
    }

    @Override
    protected void decrementChannelCount(Channel channel) {
        this.channels.decrementAndGet();
    }

    @Override
    protected void markPublishedMessage() {
        this.publishedMessages.increment();
    }

    @Override
    protected void markConsumedMessage() {
        this.consumedMessages.increment();
    }

    @Override
    protected void markAcknowledgedMessage() {
        this.acknowledgedMessages.increment();
    }

    @Override
    protected void markRejectedMessage() {
        this.rejectedMessages.increment();
    }

    public AtomicLong getConnections() {
        return this.connections;
    }

    public AtomicLong getChannels() {
        return this.channels;
    }

    public Counter getPublishedMessages() {
        return this.publishedMessages;
    }

    public Counter getConsumedMessages() {
        return this.consumedMessages;
    }

    public Counter getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public Counter getRejectedMessages() {
        return this.rejectedMessages;
    }

    public static interface MetricsCreator {
        public Object create(Metrics var1);
    }

    public static enum Metrics {
        CONNECTIONS{

            @Override
            Object create(MeterRegistry registry, String prefix, Iterable<Tag> tags) {
                return registry.gauge(prefix + ".connections", tags, (Number)new AtomicLong(0L));
            }
        }
        ,
        CHANNELS{

            @Override
            Object create(MeterRegistry registry, String prefix, Iterable<Tag> tags) {
                return registry.gauge(prefix + ".channels", tags, (Number)new AtomicLong(0L));
            }
        }
        ,
        PUBLISHED_MESSAGES{

            @Override
            Object create(MeterRegistry registry, String prefix, Iterable<Tag> tags) {
                return registry.counter(prefix + ".published", tags);
            }
        }
        ,
        CONSUMED_MESSAGES{

            @Override
            Object create(MeterRegistry registry, String prefix, Iterable<Tag> tags) {
                return registry.counter(prefix + ".consumed", tags);
            }
        }
        ,
        ACKNOWLEDGED_MESSAGES{

            @Override
            Object create(MeterRegistry registry, String prefix, Iterable<Tag> tags) {
                return registry.counter(prefix + ".acknowledged", tags);
            }
        }
        ,
        REJECTED_MESSAGES{

            @Override
            Object create(MeterRegistry registry, String prefix, Iterable<Tag> tags) {
                return registry.counter(prefix + ".rejected", tags);
            }
        };


        @Deprecated
        Object create(MeterRegistry registry, String prefix) {
            return this.create(registry, prefix, Collections.<Tag>emptyList());
        }

        abstract Object create(MeterRegistry var1, String var2, Iterable<Tag> var3);
    }
}

