/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp;

import com.rabbitmq.client.amqp.ByteCapacity;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public interface Management
extends AutoCloseable {
    public QueueSpecification queue();

    public QueueSpecification queue(String var1);

    public QueueInfo queueInfo(String var1);

    public QueueDeletion queueDeletion();

    public ExchangeSpecification exchange();

    public ExchangeSpecification exchange(String var1);

    public ExchangeDeletion exchangeDeletion();

    public BindingSpecification binding();

    public UnbindSpecification unbind();

    @Override
    public void close();

    public static interface QueueInfo {
        public String name();

        public boolean durable();

        public boolean autoDelete();

        public boolean exclusive();

        public QueueType type();

        public Map<String, Object> arguments();

        public String leader();

        @Deprecated(forRemoval=true)
        public List<String> replicas();

        public List<String> members();

        public long messageCount();

        public int consumerCount();
    }

    public static interface UnbindSpecification {
        public UnbindSpecification sourceExchange(String var1);

        public UnbindSpecification destinationQueue(String var1);

        public UnbindSpecification destinationExchange(String var1);

        public UnbindSpecification key(String var1);

        public UnbindSpecification argument(String var1, Object var2);

        public UnbindSpecification arguments(Map<String, Object> var1);

        public void unbind();
    }

    public static interface BindingSpecification {
        public BindingSpecification sourceExchange(String var1);

        public BindingSpecification destinationQueue(String var1);

        public BindingSpecification destinationExchange(String var1);

        public BindingSpecification key(String var1);

        public BindingSpecification argument(String var1, Object var2);

        public BindingSpecification arguments(Map<String, Object> var1);

        public void bind();
    }

    public static interface ExchangeDeletion {
        public void delete(String var1);
    }

    public static enum ExchangeType {
        DIRECT,
        FANOUT,
        TOPIC,
        HEADERS;

    }

    public static interface ExchangeSpecification {
        public ExchangeSpecification name(String var1);

        public ExchangeSpecification autoDelete(boolean var1);

        public ExchangeSpecification type(ExchangeType var1);

        public ExchangeSpecification type(String var1);

        public ExchangeSpecification argument(String var1, Object var2);

        public void declare();
    }

    public static interface QueueDeletion {
        public void delete(String var1);
    }

    public static enum ClassicQueueVersion {
        V1(1),
        V2(2);

        private final int version;

        private ClassicQueueVersion(int version) {
            this.version = version;
        }

        public int version() {
            return this.version;
        }
    }

    public static enum QueueLeaderLocator {
        CLIENT_LOCAL("client-local"),
        BALANCED("balanced");

        private final String locator;

        private QueueLeaderLocator(String locator) {
            this.locator = locator;
        }

        public String locator() {
            return this.locator;
        }
    }

    public static enum QueueType {
        QUORUM,
        CLASSIC,
        STREAM;

    }

    public static enum OverflowStrategy {
        DROP_HEAD("drop-head"),
        REJECT_PUBLISH("reject-publish"),
        REJECT_PUBLISH_DLX("reject-publish-dlx");

        private final String strategy;

        private OverflowStrategy(String strategy) {
            this.strategy = strategy;
        }

        public String strategy() {
            return this.strategy;
        }
    }

    public static enum QuorumQueueDeadLetterStrategy {
        AT_MOST_ONCE("at-most-once"),
        AT_LEAST_ONCE("at-least-once");

        private final String strategy;

        private QuorumQueueDeadLetterStrategy(String strategy) {
            this.strategy = strategy;
        }

        public String strategy() {
            return this.strategy;
        }
    }

    public static interface StreamSpecification {
        public StreamSpecification maxAge(Duration var1);

        public StreamSpecification maxSegmentSizeBytes(ByteCapacity var1);

        @Deprecated(forRemoval=true)
        public StreamSpecification initialClusterSize(int var1);

        public StreamSpecification initialMemberCount(int var1);

        public QueueSpecification queue();
    }

    public static interface ClassicQueueSpecification {
        public ClassicQueueSpecification maxPriority(int var1);

        public ClassicQueueSpecification version(ClassicQueueVersion var1);

        public QueueSpecification queue();
    }

    public static interface QuorumQueueSpecification {
        public QuorumQueueSpecification deadLetterStrategy(String var1);

        public QuorumQueueSpecification deadLetterStrategy(QuorumQueueDeadLetterStrategy var1);

        public QuorumQueueSpecification deliveryLimit(int var1);

        @Deprecated(forRemoval=true)
        public QuorumQueueSpecification quorumInitialGroupSize(int var1);

        public QuorumQueueSpecification initialMemberCount(int var1);

        public QueueSpecification queue();
    }

    public static interface QueueSpecification {
        public QueueSpecification name(String var1);

        public QueueSpecification exclusive(boolean var1);

        public QueueSpecification autoDelete(boolean var1);

        public QueueSpecification type(QueueType var1);

        public QueueSpecification deadLetterExchange(String var1);

        public QueueSpecification deadLetterRoutingKey(String var1);

        public QueueSpecification overflowStrategy(String var1);

        public QueueSpecification overflowStrategy(OverflowStrategy var1);

        public QueueSpecification expires(Duration var1);

        public QueueSpecification maxLength(long var1);

        public QueueSpecification maxLengthBytes(ByteCapacity var1);

        public QueueSpecification singleActiveConsumer(boolean var1);

        public QueueSpecification messageTtl(Duration var1);

        public QueueSpecification leaderLocator(QueueLeaderLocator var1);

        public QuorumQueueSpecification quorum();

        public ClassicQueueSpecification classic();

        public StreamSpecification stream();

        public QueueSpecification argument(String var1, Object var2);

        public QueueInfo declare();
    }
}

