/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.client.amqp.Message;
import com.rabbitmq.client.amqp.impl.DefaultAddressBuilder;
import com.rabbitmq.client.amqp.impl.ExceptionUtils;
import com.rabbitmq.client.amqp.impl.Utils;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.types.Binary;
import com.rabbitmq.qpid.protonj2.types.Decimal128;
import com.rabbitmq.qpid.protonj2.types.Decimal32;
import com.rabbitmq.qpid.protonj2.types.Decimal64;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedByte;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.UnsignedShort;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Date;
import java.util.UUID;
import java.util.function.BiConsumer;

final class AmqpMessage
implements Message {
    private static final byte[] EMPTY_BODY = new byte[0];
    private final com.rabbitmq.qpid.protonj2.client.Message<byte[]> delegate;

    AmqpMessage() {
        this(com.rabbitmq.qpid.protonj2.client.Message.create(EMPTY_BODY));
    }

    AmqpMessage(byte[] body) {
        this(com.rabbitmq.qpid.protonj2.client.Message.create(body));
    }

    AmqpMessage(com.rabbitmq.qpid.protonj2.client.Message<byte[]> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object messageId() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::messageId);
    }

    @Override
    public String messageIdAsString() {
        return this.returnFromDelegate(m -> (String)m.messageId());
    }

    @Override
    public long messageIdAsLong() {
        return this.returnFromDelegate(m -> ((UnsignedLong)m.messageId()).longValue());
    }

    @Override
    public byte[] messageIdAsBinary() {
        return this.returnFromDelegate(m -> ((Binary)m.messageId()).asByteArray());
    }

    @Override
    public UUID messageIdAsUuid() {
        return this.returnFromDelegate(m -> (UUID)m.messageId());
    }

    @Override
    public Object correlationId() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::correlationId);
    }

    @Override
    public String correlationIdAsString() {
        return this.returnFromDelegate(m -> (String)m.correlationId());
    }

    @Override
    public long correlationIdAsLong() {
        return this.returnFromDelegate(m -> (UnsignedLong)m.correlationId()).longValue();
    }

    @Override
    public byte[] correlationIdAsBinary() {
        return this.returnFromDelegate(m -> ((Binary)m.correlationId()).asByteArray());
    }

    @Override
    public UUID correlationIdAsUuid() {
        return this.returnFromDelegate(m -> (UUID)m.correlationId());
    }

    @Override
    public byte[] userId() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::userId);
    }

    @Override
    public String to() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::to);
    }

    @Override
    public String subject() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::subject);
    }

    @Override
    public String replyTo() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::replyTo);
    }

    @Override
    public Message messageId(Object id) {
        this.callOnDelegate(m -> m.messageId(id));
        return this;
    }

    @Override
    public Message messageId(String id) {
        this.callOnDelegate(m -> m.messageId(id));
        return this;
    }

    @Override
    public Message messageId(long id) {
        this.callOnDelegate(m -> m.messageId(new UnsignedLong(id)));
        return this;
    }

    @Override
    public Message messageId(byte[] id) {
        this.callOnDelegate(m -> m.messageId(new Binary(id)));
        return this;
    }

    @Override
    public Message messageId(UUID id) {
        this.callOnDelegate(m -> m.messageId(id));
        return this;
    }

    @Override
    public Message correlationId(Object correlationId) {
        this.callOnDelegate(m -> m.correlationId(correlationId));
        return this;
    }

    @Override
    public Message correlationId(String correlationId) {
        this.callOnDelegate(m -> m.correlationId(correlationId));
        return this;
    }

    @Override
    public Message correlationId(long correlationId) {
        this.callOnDelegate(m -> m.correlationId(UnsignedLong.valueOf(correlationId)));
        return this;
    }

    @Override
    public Message correlationId(byte[] correlationId) {
        this.callOnDelegate(m -> m.correlationId(new Binary(correlationId)));
        return this;
    }

    @Override
    public Message correlationId(UUID correlationId) {
        this.callOnDelegate(m -> m.correlationId(correlationId));
        return this;
    }

    @Override
    public Message userId(byte[] userId) {
        this.callOnDelegate(m -> m.userId(userId));
        return this;
    }

    @Override
    public Message to(String address) {
        this.callOnDelegate(m -> m.to(address));
        return this;
    }

    @Override
    public Message subject(String subject) {
        this.callOnDelegate(m -> m.subject(subject));
        return this;
    }

    @Override
    public Message replyTo(String replyTo) {
        this.callOnDelegate(m -> m.replyTo(replyTo));
        return this;
    }

    @Override
    public Message contentType(String contentType) {
        this.callOnDelegate(m -> m.contentType(contentType));
        return this;
    }

    @Override
    public Message contentEncoding(String contentEncoding) {
        this.callOnDelegate(m -> m.contentEncoding(contentEncoding));
        return this;
    }

    @Override
    public Message absoluteExpiryTime(long absoluteExpiryTime) {
        this.callOnDelegate(m -> m.absoluteExpiryTime(absoluteExpiryTime));
        return this;
    }

    @Override
    public Message creationTime(long creationTime) {
        this.callOnDelegate(m -> m.creationTime(creationTime));
        return this;
    }

    @Override
    public Message groupId(String groupID) {
        this.callOnDelegate(m -> m.groupId(groupID));
        return this;
    }

    @Override
    public Message groupSequence(int groupSequence) {
        this.callOnDelegate(m -> m.groupSequence(groupSequence));
        return this;
    }

    @Override
    public Message replyToGroupId(String groupId) {
        this.callOnDelegate(m -> m.replyToGroupId(groupId));
        return this;
    }

    @Override
    public String contentType() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::contentType);
    }

    @Override
    public String contentEncoding() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::contentEncoding);
    }

    @Override
    public long absoluteExpiryTime() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::absoluteExpiryTime);
    }

    @Override
    public long creationTime() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::creationTime);
    }

    @Override
    public String groupId() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::groupId);
    }

    @Override
    public int groupSequence() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::groupSequence);
    }

    @Override
    public String replyToGroupId() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::replyToGroupId);
    }

    @Override
    public Object property(String key) {
        Object value = this.returnFromDelegate(m -> m.property(key));
        if (value instanceof Binary) {
            return ((Binary)value).asByteArray();
        }
        return value;
    }

    @Override
    public Message property(String key, boolean value) {
        this.callOnDelegate(m -> m.property(key, value));
        return this;
    }

    @Override
    public Message property(String key, byte value) {
        this.callOnDelegate(m -> m.property(key, value));
        return this;
    }

    @Override
    public Message property(String key, short value) {
        this.callOnDelegate(m -> m.property(key, value));
        return this;
    }

    @Override
    public Message property(String key, int value) {
        this.callOnDelegate(m -> m.property(key, value));
        return this;
    }

    @Override
    public Message property(String key, long value) {
        this.callOnDelegate(m -> m.property(key, value));
        return this;
    }

    @Override
    public Message propertyUnsigned(String key, byte value) {
        this.callOnDelegate(m -> m.property(key, new UnsignedByte(value)));
        return this;
    }

    @Override
    public Message propertyUnsigned(String key, short value) {
        this.callOnDelegate(m -> m.property(key, new UnsignedShort(value)));
        return this;
    }

    @Override
    public Message propertyUnsigned(String key, int value) {
        this.callOnDelegate(m -> m.property(key, new UnsignedInteger(value)));
        return this;
    }

    @Override
    public Message propertyUnsigned(String key, long value) {
        this.callOnDelegate(m -> m.property(key, new UnsignedLong(value)));
        return this;
    }

    @Override
    public Message property(String key, float value) {
        this.callOnDelegate(m -> m.property(key, Float.valueOf(value)));
        return this;
    }

    @Override
    public Message property(String key, double value) {
        this.callOnDelegate(m -> m.property(key, value));
        return this;
    }

    @Override
    public Message propertyDecimal32(String key, BigDecimal value) {
        this.callOnDelegate(m -> m.property(key, new Decimal32(value)));
        return this;
    }

    @Override
    public Message propertyDecimal64(String key, BigDecimal value) {
        this.callOnDelegate(m -> m.property(key, new Decimal64(value)));
        return this;
    }

    @Override
    public Message propertyDecimal128(String key, BigDecimal value) {
        this.callOnDelegate(m -> m.property(key, new Decimal128(value)));
        return this;
    }

    @Override
    public Message property(String key, char value) {
        this.callOnDelegate(m -> m.property(key, Character.valueOf(value)));
        return this;
    }

    @Override
    public Message propertyTimestamp(String key, long value) {
        this.callOnDelegate(m -> m.property(key, new Date(value)));
        return this;
    }

    @Override
    public Message property(String key, UUID value) {
        this.callOnDelegate(m -> m.property(key, value));
        return this;
    }

    @Override
    public Message property(String key, byte[] value) {
        this.callOnDelegate(m -> m.property(key, new Binary(value)));
        return this;
    }

    @Override
    public Message property(String key, String value) {
        this.callOnDelegate(m -> m.property(key, value));
        return this;
    }

    @Override
    public Message propertySymbol(String key, String value) {
        this.callOnDelegate(m -> m.property(key, Symbol.getSymbol(value)));
        return this;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.returnFromDelegate(m -> m.hasProperty(key));
    }

    @Override
    public boolean hasProperties() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::hasProperties);
    }

    @Override
    public Object removeProperty(String key) {
        return this.returnFromDelegate(m -> m.removeProperty(key));
    }

    @Override
    public Message forEachProperty(BiConsumer<String, Object> action) {
        this.callOnDelegate(m -> m.forEachProperty(action));
        return this;
    }

    @Override
    public Message body(byte[] body) {
        try {
            this.delegate.body(body);
        }
        catch (ClientException e) {
            throw ExceptionUtils.convert(e);
        }
        return this;
    }

    @Override
    public byte[] body() {
        try {
            return this.delegate.body();
        }
        catch (ClientException e) {
            throw ExceptionUtils.convert(e);
        }
    }

    @Override
    public boolean durable() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::durable);
    }

    @Override
    public Message priority(byte priority) {
        this.callOnDelegate(m -> m.priority(priority));
        return this;
    }

    @Override
    public byte priority() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::priority);
    }

    @Override
    public Message ttl(Duration ttl) {
        if (ttl == null) {
            throw new IllegalArgumentException("TTL cannot be null");
        }
        this.callOnDelegate(m -> m.timeToLive(ttl.toMillis()));
        return this;
    }

    @Override
    public Duration ttl() {
        return this.returnFromDelegate(m -> Duration.ofMillis(m.timeToLive()));
    }

    @Override
    public boolean firstAcquirer() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::firstAcquirer);
    }

    @Override
    public Object annotation(String key) {
        return this.returnFromDelegate(m -> m.annotation(key));
    }

    @Override
    public Message annotation(String key, Object value) {
        Utils.validateMessageAnnotationKey(key);
        this.callOnDelegate(m -> m.annotation(key, value));
        return this;
    }

    @Override
    public boolean hasAnnotation(String key) {
        return this.returnFromDelegate(m -> m.hasAnnotation(key));
    }

    @Override
    public boolean hasAnnotations() {
        return this.returnFromDelegate(com.rabbitmq.qpid.protonj2.client.Message::hasAnnotations);
    }

    @Override
    public Object removeAnnotation(String key) {
        return this.returnFromDelegate(m -> m.removeAnnotation(key));
    }

    @Override
    public Message forEachAnnotation(BiConsumer<String, Object> action) {
        this.callOnDelegate(m -> m.forEachAnnotation(action));
        return this;
    }

    @Override
    public Message.MessageAddressBuilder toAddress() {
        return new DefaultMessageAddressBuilder(this, DefaultMessageAddressBuilder.TO_CALLBACK);
    }

    @Override
    public Message.MessageAddressBuilder replyToAddress() {
        return new DefaultMessageAddressBuilder(this, DefaultMessageAddressBuilder.REPLY_TO_CALLBACK);
    }

    private void callOnDelegate(CallableConsumer call) {
        try {
            call.accept(this.delegate);
        }
        catch (ClientException e) {
            throw ExceptionUtils.convert(e);
        }
    }

    private <E> E returnFromDelegate(MessageFunctionCallable<E> call) {
        try {
            return call.call(this.delegate);
        }
        catch (ClientException e) {
            throw new AmqpException(e);
        }
    }

    com.rabbitmq.qpid.protonj2.client.Message<?> nativeMessage() {
        return this.delegate;
    }

    private static interface MessageFunctionCallable<T> {
        public T call(com.rabbitmq.qpid.protonj2.client.Message<?> var1) throws ClientException;
    }

    private static interface CallableConsumer {
        public void accept(com.rabbitmq.qpid.protonj2.client.Message<?> var1) throws ClientException;
    }

    private static class DefaultMessageAddressBuilder
    extends DefaultAddressBuilder<Message.MessageAddressBuilder>
    implements Message.MessageAddressBuilder {
        private static final BiConsumer<Message, String> TO_CALLBACK = Message::to;
        private static final BiConsumer<Message, String> REPLY_TO_CALLBACK = Message::replyTo;
        private final Message message;
        private final BiConsumer<Message, String> buildCallback;

        private DefaultMessageAddressBuilder(Message message, BiConsumer<Message, String> buildCallback) {
            super(null);
            this.message = message;
            this.buildCallback = buildCallback;
        }

        @Override
        Message.MessageAddressBuilder result() {
            return this;
        }

        @Override
        public Message message() {
            this.buildCallback.accept(this.message, this.address());
            return this.message;
        }
    }
}

