/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.AddressBuilder;
import com.rabbitmq.client.amqp.Publisher;
import com.rabbitmq.client.amqp.PublisherBuilder;
import com.rabbitmq.client.amqp.Resource;
import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.DefaultAddressBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

class AmqpPublisherBuilder
implements PublisherBuilder {
    private final AmqpConnection connection;
    private final List<Resource.StateListener> listeners = new ArrayList<Resource.StateListener>();
    private final DefaultAddressBuilder<PublisherBuilder> addressBuilder = new DefaultAddressBuilder<PublisherBuilder>((PublisherBuilder)this){};
    private Duration publishTimeout = Duration.ofSeconds(60L);

    AmqpPublisherBuilder(AmqpConnection connection) {
        this.connection = connection;
    }

    @Override
    public PublisherBuilder exchange(String exchange) {
        return this.addressBuilder.exchange(exchange);
    }

    @Override
    public PublisherBuilder key(String key) {
        return this.addressBuilder.key(key);
    }

    @Override
    public PublisherBuilder queue(String queue) {
        return this.addressBuilder.queue(queue);
    }

    @Override
    public PublisherBuilder listeners(Resource.StateListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            this.listeners.clear();
        } else {
            this.listeners.addAll(List.of(listeners));
        }
        return this;
    }

    @Override
    public AmqpPublisherBuilder publishTimeout(Duration publishTimeout) {
        this.publishTimeout = publishTimeout;
        return this;
    }

    @Override
    public Publisher build() {
        return this.connection.createPublisher(this);
    }

    AmqpConnection connection() {
        return this.connection;
    }

    List<Resource.StateListener> listeners() {
        return this.listeners;
    }

    AddressBuilder<?> addressBuilder() {
        return this.addressBuilder;
    }

    String address() {
        return this.addressBuilder.address();
    }

    DefaultAddressBuilder.DestinationSpec destination() {
        return this.addressBuilder.destination();
    }

    Duration publishTimeout() {
        return this.publishTimeout;
    }
}

