/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.qpid.protonj2.client.ErrorCondition;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientConnectionSecurityException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientLinkRemotelyClosedException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientSessionRemotelyClosedException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;

abstract class ExceptionUtils {
    static final String ERROR_UNAUTHORIZED_ACCESS = "amqp:unauthorized-access";
    static final String ERROR_NOT_FOUND = "amqp:not-found";
    static final String ERROR_RESOURCE_DELETED = "amqp:resource-deleted";

    private ExceptionUtils() {
    }

    static <T> T wrapGet(Future<T> future) throws ClientException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ClientException) {
                throw (ClientException)e.getCause();
            }
            throw ExceptionUtils.convert(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmqpException(e);
        }
    }

    static AmqpException convert(ClientException e) {
        return ExceptionUtils.convert(e, null, new Object[0]);
    }

    static AmqpException convert(ExecutionException e) {
        if (e.getCause() instanceof ClientException) {
            return ExceptionUtils.convert((ClientException)e.getCause());
        }
        return new AmqpException(e.getCause() == null ? e : e.getCause());
    }

    static AmqpException convert(ClientException e, String format, Object ... args) {
        String message;
        String string = message = format != null ? String.format(format, args) : null;
        if (e.getCause() instanceof SSLException) {
            return new AmqpException.AmqpSecurityException(message, e.getCause());
        }
        if (e instanceof ClientConnectionSecurityException) {
            return new AmqpException.AmqpSecurityException(message, e);
        }
        if (ExceptionUtils.isNetworkError(e)) {
            return new AmqpException.AmqpConnectionException(e.getMessage(), e);
        }
        if (e instanceof ClientSessionRemotelyClosedException || e instanceof ClientLinkRemotelyClosedException) {
            ErrorCondition errorCondition = ((ClientResourceRemotelyClosedException)e).getErrorCondition();
            if (ExceptionUtils.isUnauthorizedAccess(errorCondition)) {
                return new AmqpException.AmqpSecurityException(e.getMessage(), e);
            }
            if (ExceptionUtils.isNotFound(errorCondition)) {
                return new AmqpException.AmqpEntityDoesNotExistException(e.getMessage(), e);
            }
            if (ExceptionUtils.isResourceDeleted(errorCondition)) {
                return new AmqpException.AmqpEntityDoesNotExistException(e.getMessage(), e);
            }
            return new AmqpException.AmqpResourceClosedException(e.getMessage(), e);
        }
        if (e instanceof ClientConnectionRemotelyClosedException) {
            ErrorCondition errorCondition = ((ClientConnectionRemotelyClosedException)e).getErrorCondition();
            if (ExceptionUtils.isNetworkError(e) || !ExceptionUtils.isUnauthorizedAccess(errorCondition)) {
                return new AmqpException.AmqpConnectionException(e.getMessage(), e);
            }
            return new AmqpException(e.getMessage(), e);
        }
        return new AmqpException(message, e);
    }

    static boolean resourceDeleted(ClientResourceRemotelyClosedException e) {
        return e.getErrorCondition() != null && ERROR_RESOURCE_DELETED.equals(e.getErrorCondition().condition());
    }

    static boolean notFound(ClientResourceRemotelyClosedException e) {
        return e.getErrorCondition() != null && ERROR_NOT_FOUND.equals(e.getErrorCondition().condition());
    }

    static boolean unauthorizedAccess(ClientResourceRemotelyClosedException e) {
        return ExceptionUtils.isUnauthorizedAccess(e.getErrorCondition());
    }

    private static boolean isUnauthorizedAccess(ErrorCondition errorCondition) {
        return ExceptionUtils.errorConditionEquals(errorCondition, ERROR_UNAUTHORIZED_ACCESS);
    }

    private static boolean isNotFound(ErrorCondition errorCondition) {
        return ExceptionUtils.errorConditionEquals(errorCondition, ERROR_NOT_FOUND);
    }

    private static boolean isResourceDeleted(ErrorCondition errorCondition) {
        return ExceptionUtils.errorConditionEquals(errorCondition, ERROR_RESOURCE_DELETED);
    }

    private static boolean errorConditionEquals(ErrorCondition errorCondition, String expected) {
        return errorCondition != null && expected.equals(errorCondition.condition());
    }

    private static boolean isNetworkError(ClientException e) {
        String message;
        if (e instanceof ClientConnectionRemotelyClosedException && (message = e.getMessage()) != null) {
            return (message = message.toLowerCase()).contains("connection reset") || message.contains("connection refused");
        }
        return false;
    }

    static boolean maybeCloseConsumerOnException(Consumer<Throwable> closing, Exception ex) {
        ClientResourceRemotelyClosedException e;
        if ((ex instanceof ClientLinkRemotelyClosedException || ex instanceof ClientSessionRemotelyClosedException) && (ExceptionUtils.notFound(e = (ClientResourceRemotelyClosedException)ex) || ExceptionUtils.resourceDeleted(e) || ExceptionUtils.unauthorizedAccess(e))) {
            closing.accept(ExceptionUtils.convert(e));
            return true;
        }
        return false;
    }
}

