/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.client.amqp.Resource;
import com.rabbitmq.client.amqp.impl.StateEventSupport;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

abstract class ResourceBase
implements Resource {
    private final AtomicReference<Resource.State> state = new AtomicReference();
    private final StateEventSupport stateEventSupport;
    private volatile Throwable closeReason;

    ResourceBase(List<Resource.StateListener> listeners) {
        this.stateEventSupport = new StateEventSupport(listeners);
        this.state(Resource.State.OPENING);
    }

    protected void checkOpen() {
        Resource.State state = this.state.get();
        if (state != Resource.State.OPEN && this.closeReason instanceof AmqpException) {
            throw (AmqpException)this.closeReason;
        }
        if (state == Resource.State.CLOSED) {
            throw new AmqpException.AmqpResourceClosedException("Resource is closed");
        }
        if (state != Resource.State.OPEN) {
            throw new AmqpException.AmqpResourceInvalidStateException("Resource is not open, current state is %s", this.state.get().name());
        }
    }

    protected Resource.State state() {
        return this.state.get();
    }

    protected void state(Resource.State state) {
        this.state(state, null);
    }

    protected void state(Resource.State state, Throwable failureCause) {
        Resource.State previousState = this.state.getAndSet(state);
        if (state != previousState) {
            if ((state == Resource.State.CLOSING || state == Resource.State.CLOSED) && this.closeReason == null) {
                this.closeReason = failureCause;
            }
            this.dispatch(previousState, state, failureCause);
        }
    }

    private void dispatch(Resource.State previous, Resource.State current, Throwable failureCause) {
        this.stateEventSupport.dispatch(this, failureCause, previous, current);
    }
}

