/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.observation.micrometer;

import com.rabbitmq.client.amqp.Consumer;
import com.rabbitmq.client.amqp.Message;
import com.rabbitmq.client.amqp.ObservationCollector;
import com.rabbitmq.client.amqp.observation.micrometer.AmqpObservationDocumentation;
import com.rabbitmq.client.amqp.observation.micrometer.DeliverContext;
import com.rabbitmq.client.amqp.observation.micrometer.DeliverObservationConvention;
import com.rabbitmq.client.amqp.observation.micrometer.PublishContext;
import com.rabbitmq.client.amqp.observation.micrometer.PublishObservationConvention;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.function.Function;

class MicrometerObservationCollector
implements ObservationCollector {
    private final ObservationRegistry registry;
    private final PublishObservationConvention customPublishConvention;
    private final PublishObservationConvention defaultPublishConvention;
    private final DeliverObservationConvention customProcessConvention;
    private final DeliverObservationConvention defaultProcessConvention;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    MicrometerObservationCollector(ObservationRegistry registry, PublishObservationConvention customPublishConvention, PublishObservationConvention defaultPublishConvention, DeliverObservationConvention customProcessConvention, DeliverObservationConvention defaultProcessConvention) {
        this.registry = registry;
        this.customPublishConvention = customPublishConvention;
        this.defaultPublishConvention = defaultPublishConvention;
        this.customProcessConvention = customProcessConvention;
        this.defaultProcessConvention = defaultProcessConvention;
    }

    @Override
    public <T> T publish(String exchange, String routingKey, Message message, ObservationCollector.ConnectionInfo connectionInfo, Function<Message, T> publishCall) {
        PublishContext context = new PublishContext(exchange, routingKey, message, connectionInfo);
        Observation observation = AmqpObservationDocumentation.PUBLISH_OBSERVATION.observation(this.customPublishConvention, this.defaultPublishConvention, () -> context, this.registry);
        observation.start();
        try {
            T t = publishCall.apply(message);
            return t;
        }
        catch (RuntimeException e) {
            observation.error((Throwable)e);
            throw e;
        }
        finally {
            observation.stop();
        }
    }

    @Override
    public Consumer.MessageHandler subscribe(String queue, Consumer.MessageHandler handler) {
        return new ObservationMessageHandler(queue, handler, this.registry, this.customProcessConvention, this.defaultProcessConvention);
    }

    private static String extractExchange(Message message) {
        Object exchange = message.annotation("x-exchange");
        return exchange == null ? null : exchange.toString();
    }

    private static String extractRoutingKey(Message message) {
        Object routingKey = message.annotation("x-routing-key");
        return routingKey == null ? null : routingKey.toString();
    }

    private static final class ObservationMessageHandler
    implements Consumer.MessageHandler {
        private final String queue;
        private final Consumer.MessageHandler delegate;
        private final ObservationRegistry registry;
        private final DeliverObservationConvention customProcessConvention;
        private final DeliverObservationConvention defaultProcessConvention;

        private ObservationMessageHandler(String queue, Consumer.MessageHandler delegate, ObservationRegistry registry, DeliverObservationConvention customProcessConvention, DeliverObservationConvention defaultProcessConvention) {
            this.queue = queue;
            this.delegate = delegate;
            this.registry = registry;
            this.customProcessConvention = customProcessConvention;
            this.defaultProcessConvention = defaultProcessConvention;
        }

        @Override
        public void handle(Consumer.Context context, Message message) {
            DeliverContext deliverContext = new DeliverContext(MicrometerObservationCollector.extractExchange(message), MicrometerObservationCollector.extractRoutingKey(message), this.queue, message);
            Observation observation = AmqpObservationDocumentation.PROCESS_OBSERVATION.observation(this.customProcessConvention, this.defaultProcessConvention, () -> deliverContext, this.registry);
            observation.observeChecked(() -> this.delegate.handle(context, message));
        }
    }
}

