/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.DeliveryState;
import com.rabbitmq.qpid.protonj2.client.Sender;
import com.rabbitmq.qpid.protonj2.client.Tracker;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import com.rabbitmq.qpid.protonj2.client.impl.ClientSender;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public final class ClientNoOpTracker
implements Tracker {
    private final ClientSender sender;
    private DeliveryState state;
    private boolean settled;

    ClientNoOpTracker(ClientSender sender) {
        this.sender = sender;
    }

    @Override
    public Sender sender() {
        return this.sender;
    }

    @Override
    public Tracker settle() throws ClientException {
        this.settled = true;
        return this;
    }

    @Override
    public boolean settled() {
        return this.settled;
    }

    @Override
    public DeliveryState state() {
        return this.state;
    }

    @Override
    public Tracker disposition(DeliveryState state, boolean settle) throws ClientException {
        this.state = state;
        this.settled = settle;
        return this;
    }

    @Override
    public DeliveryState remoteState() {
        return ClientDeliveryState.ClientAccepted.getInstance();
    }

    @Override
    public boolean remoteSettled() {
        return true;
    }

    @Override
    public CompletableFuture<Tracker> settlementFuture() {
        CompletableFuture<Tracker> result = new CompletableFuture<Tracker>();
        result.complete(this);
        return result;
    }

    @Override
    public Tracker awaitSettlement() throws ClientException {
        return this;
    }

    @Override
    public Tracker awaitSettlement(long timeout, TimeUnit unit) throws ClientException {
        return this;
    }

    @Override
    public Tracker awaitAccepted() throws ClientException {
        return this;
    }

    @Override
    public Tracker awaitAccepted(long timeout, TimeUnit unit) throws ClientException {
        return this;
    }
}

