/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.BinaryTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Binary;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractBinaryTypeDecoder
extends AbstractPrimitiveTypeDecoder<Binary>
implements BinaryTypeDecoder {
    @Override
    public Binary readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return new Binary(this.readValueAsBuffer(buffer, state));
    }

    public ProtonBuffer readValueAsBuffer(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int length = this.readSize(buffer, state);
        if (length > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Binary data size %d is specified to be greater than the amount of data available (%d)", length, buffer.getReadableBytes()));
        }
        ProtonBuffer payload = buffer.copy(buffer.getReadOffset(), length, true);
        buffer.advanceReadOffset(length);
        return payload;
    }

    public byte[] readValueAsArray(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int length = this.readSize(buffer, state);
        if (length > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Binary data size %d is specified to be greater than the amount of data available (%d)", length, buffer.getReadableBytes()));
        }
        byte[] payload = new byte[length];
        buffer.readBytes(payload, 0, payload.length);
        return payload;
    }

    @Override
    public Binary readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return new Binary(this.readValueAsBuffer(stream, state));
    }

    public ProtonBuffer readValueAsBuffer(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonBufferAllocator.defaultAllocator().copy(this.readValueAsArray(stream, state)).convertToReadOnly();
    }

    public byte[] readValueAsArray(InputStream stream, StreamDecoderState state) throws DecodeException {
        int length = this.readSize(stream, state);
        byte[] payload = new byte[length];
        try {
            stream.read(payload);
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading Binary payload bytes", ex);
        }
        return payload;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int length = this.readSize(buffer, state);
        if (length > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Binary data size %d is specified to be greater than the amount of data available (%d)", length, buffer.getReadableBytes()));
        }
        buffer.advanceReadOffset(length);
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        try {
            stream.skip(this.readSize(stream, state));
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading Binary payload bytes", ex);
        }
    }
}

